/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.Map;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.ClusterNodeMap;
import tigase.util.JIDUtils;
import tigase.xmpp.Authorization;

public class ViewNodeLoadCommand
implements AdHocCommand {
    private final PubSubConfig config;
    private final ClusterNodeMap nodeMap;

    public ViewNodeLoadCommand(PubSubConfig config, ClusterNodeMap nodeMap) {
        this.config = config;
        this.nodeMap = nodeMap;
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)request.getSender()))) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Form form = new Form("result", "Cluster nodes load", "Statistics of cluster nodes");
            for (Map.Entry<String, Integer> entry : this.nodeMap.getClusterNodesLoad().entrySet()) {
                Field field = Field.fieldTextSingle((String)("tigase#node-" + entry.getKey()), (String)entry.getValue().toString(), (String)entry.getKey());
                form.addField(field);
            }
            response.getElements().add(form.getElement());
            response.completeSession();
        }
        catch (AdHocCommandException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "View cluster load";
    }

    @Override
    public String getNode() {
        return "cluster-load";
    }
}

