/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.ComponentConfig;
import tigase.component.ElementWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.ModulesManager;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.StanzaType;

public abstract class AbstractComponent<T extends ComponentConfig>
extends AbstractMessageReceiver
implements XMPPService {
    protected final T componentConfig;
    private final ElementWriter DEFAULT_WRITER = new ElementWriter(){

        @Override
        public void write(Collection<Packet> elements) {
            if (elements != null) {
                for (Packet element : elements) {
                    if (element == null) continue;
                    this.write(element);
                }
            }
        }

        @Override
        public void write(Packet packet) {
            if (AbstractComponent.this.log.isLoggable(Level.FINER)) {
                AbstractComponent.this.log.finer("Sent: " + packet.getElement());
            }
            AbstractComponent.this.addOutPacket(packet);
        }

        @Override
        public void writeElement(Collection<Element> elements) {
            if (elements != null) {
                for (Element element : elements) {
                    if (element == null) continue;
                    this.writeElement(element);
                }
            }
        }

        @Override
        public void writeElement(Element element) {
            if (element != null) {
                try {
                    if (AbstractComponent.this.log.isLoggable(Level.FINER)) {
                        AbstractComponent.this.log.finer("Sent: " + element);
                    }
                    AbstractComponent.this.addOutPacket(Packet.packetInstance((Element)element));
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    // empty catch block
                }
            }
        }
    };
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected final ModulesManager modulesManager = new ModulesManager();
    private final ElementWriter writer;

    public AbstractComponent() {
        this(null);
    }

    public AbstractComponent(ElementWriter writer) {
        this.writer = writer != null ? writer : this.DEFAULT_WRITER;
        this.componentConfig = this.createComponentConfigInstance(this);
    }

    protected abstract T createComponentConfigInstance(AbstractComponent<?> var1);

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        Map<String, Object> x = ((ComponentConfig)this.componentConfig).getDefaults(props);
        if (x != null) {
            props.putAll(x);
        }
        return props;
    }

    protected ElementWriter getWriter() {
        return this.writer;
    }

    protected void processCommandPacket(Packet packet) {
        ArrayDeque results = new ArrayDeque();
        this.processScriptCommand(packet, results);
        if (results.size() > 0) {
            for (Packet res : results) {
                this.addOutPacketNB(res);
            }
        }
    }

    public void processPacket(Packet packet) {
        if (packet.isCommand()) {
            this.processCommandPacket(packet);
        } else {
            this.processStanzaPacket(packet);
        }
    }

    protected void processStanzaPacket(Packet packet) {
        try {
            boolean handled = this.modulesManager.process(packet, this.getWriter());
            if (!handled) {
                StanzaType type;
                String t = packet.getElement().getAttributeStaticStr("type");
                StanzaType stanzaType = type = t == null ? null : StanzaType.valueof((String)t);
                if (type != StanzaType.error) {
                    throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(packet.getElemName() + " stanza with type='error' ignored");
                }
            }
        }
        catch (TigaseStringprepException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessage() + " when processing " + packet.toString());
            }
            this.sendException(packet, new ComponentException(Authorization.JID_MALFORMED));
        }
        catch (ComponentException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessageWithPosition() + " when processing " + packet.toString());
            }
            this.sendException(packet, e);
        }
    }

    protected void sendException(Packet packet, ComponentException e) {
        block5: {
            try {
                String t = packet.getElement().getAttributeStaticStr("type");
                if (t != null && t == "error") {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer(packet.getElemName() + " stanza already with type='error' ignored");
                    }
                    return;
                }
                Packet result = e.makeElement(packet, true);
                Element el = result.getElement();
                el.setAttribute("from", BareJID.bareJIDInstance((String)el.getAttributeStaticStr("from")).toString());
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Sending back: " + result.toString());
                }
                this.getWriter().write(result);
            }
            catch (Exception e1) {
                if (!this.log.isLoggable(Level.WARNING)) break block5;
                this.log.log(Level.WARNING, "Problem during generate error response", e1);
            }
        }
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        ((ComponentConfig)this.componentConfig).setProperties(props);
    }
}

