/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class RebuildDatabaseCommand
implements AdHocCommand {
    private final PubSubConfig config;
    private final PubSubDAO dao;

    public RebuildDatabaseCommand(PubSubConfig config, PubSubDAO directPubSubRepository) {
        this.dao = directPubSubRepository;
        this.config = config;
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)request.getSender()))) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("result", "Rebuild nodes tree", "To rebuild tree of nodes please check checkbox.");
                form.addField(Field.fieldBoolean((String)"tigase-pubsub#rebuild", (Boolean)Boolean.FALSE, (String)"Rebuild nodes tree?"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    Boolean rebuild = form.getAsBoolean("tigase-pubsub#rebuild");
                    if (rebuild != null && rebuild.booleanValue()) {
                        this.startRebuild();
                        Form f = new Form(null, "Info", "Nodes tree has been rebuild");
                        response.getElements().add(f.getElement());
                    } else {
                        Form f = new Form(null, "Info", "Rebuild cancelled.");
                        response.getElements().add(f.getElement());
                    }
                }
                response.completeSession();
            }
        }
        catch (AdHocCommandException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Rebuild database";
    }

    @Override
    public String getNode() {
        return "rebuild-db";
    }

    private void startRebuild() throws RepositoryException {
        String nodeName2;
        String[] allNodesId = this.dao.getNodesList();
        HashSet<String> rootCollection = new HashSet<String>();
        HashMap<String, AbstractNodeConfig> nodeConfigs = new HashMap<String, AbstractNodeConfig>();
        for (String nodeName2 : allNodesId) {
            AbstractNodeConfig nodeConfig = this.dao.getNodeConfig(nodeName2);
            nodeConfigs.put(nodeName2, nodeConfig);
            if (!(nodeConfig instanceof CollectionNodeConfig)) continue;
            CollectionNodeConfig collectionNodeConfig = (CollectionNodeConfig)nodeConfig;
            collectionNodeConfig.setChildren(null);
        }
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)entry.getValue();
            nodeName2 = (String)entry.getKey();
            String collectionNodeName = nodeConfig.getCollection();
            if (collectionNodeName == null || collectionNodeName.equals("")) {
                nodeConfig.setCollection("");
                rootCollection.add(nodeName2);
                continue;
            }
            AbstractNodeConfig potentialParent = (AbstractNodeConfig)nodeConfigs.get(collectionNodeName);
            if (potentialParent != null && potentialParent instanceof CollectionNodeConfig) {
                CollectionNodeConfig collectionConfig = (CollectionNodeConfig)potentialParent;
                collectionConfig.addChildren(nodeName2);
                continue;
            }
            nodeConfig.setCollection("");
            rootCollection.add(nodeName2);
        }
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)entry.getValue();
            nodeName2 = (String)entry.getKey();
            this.dao.update(nodeName2, nodeConfig);
        }
        this.dao.removeAllFromRootCollection();
        for (String nodeName3 : rootCollection) {
            this.dao.addToRootCollection(nodeName3);
        }
    }
}

