/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.ElementWriter;
import tigase.pubsub.Module;
import tigase.pubsub.exceptions.PubSubException;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class PresenceCollectorModule
implements Module {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final Map<String, Set<String>> resources = new HashMap<String, Set<String>>();

    public synchronized boolean addJid(String jid) {
        if (jid == null) {
            return false;
        }
        boolean added = false;
        String bareJid = JIDUtils.getNodeID((String)jid);
        String resource = JIDUtils.getNodeResource((String)jid);
        if (resource != null) {
            Set<String> resources = this.resources.get(bareJid);
            if (resources == null) {
                resources = new HashSet<String>();
                this.resources.put(bareJid, resources);
            }
            added = resources.add(resource);
            this.log.finest("Contact " + jid + " is collected.");
        }
        return added;
    }

    public List<String> getAllAvailableJids() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : this.resources.entrySet()) {
            for (String reource : entry.getValue()) {
                result.add(entry.getKey() + "/" + reource);
            }
        }
        return result;
    }

    public List<String> getAllAvailableResources(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        ArrayList<String> result = new ArrayList<String>();
        Set<String> resources = this.resources.get(bareJid);
        if (resources != null) {
            for (String reource : resources) {
                result.add(bareJid + "/" + reource);
            }
        }
        return result;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#presence-notifications"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isJidAvailable(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        Set<String> resources = this.resources.get(bareJid);
        return resources != null && resources.size() > 0;
    }

    private Element preparePresence(Element presence, String type) {
        String to = presence.getAttribute("from");
        if (to != null) {
            String jid = JIDUtils.getNodeID((String)to);
            Element p = new Element("presence", new String[]{"to", "from"}, new String[]{jid, presence.getAttribute("to")});
            if (type != null) {
                p.setAttribute("type", type);
            }
            return p;
        }
        return null;
    }

    @Override
    public List<Element> process(Element element, ElementWriter elementWriter) throws PubSubException {
        String type = element.getAttribute("type");
        String jid = element.getAttribute("from");
        ArrayList<Element> result = new ArrayList<Element>();
        if (type == null) {
            boolean added = this.addJid(jid);
            if (added) {
                Element p = new Element("presence", new String[]{"to", "from"}, new String[]{jid, element.getAttribute("to")});
                result.add(p);
            }
        } else if ("unavailable".equals(type)) {
            this.removeJid(jid);
            Element p = new Element("presence", new String[]{"to", "from", "type"}, new String[]{jid, element.getAttribute("to"), "unavailable"});
            result.add(p);
        } else if ("subscribe".equals(type)) {
            this.log.finest("Contact " + jid + " wants to subscribe PubSub");
            Element presence = this.preparePresence(element, "subscribed");
            if (presence != null) {
                result.add(presence);
            }
            if ((presence = this.preparePresence(element, "subscribe")) != null) {
                result.add(presence);
            }
        } else if ("unsubscribe".equals(type) || "unsubscribed".equals(type)) {
            this.log.finest("Contact " + jid + " wants to unsubscribe PubSub");
            Element presence = this.preparePresence(element, "unsubscribed");
            if (presence != null) {
                result.add(presence);
            }
            if ((presence = this.preparePresence(element, "unsubscribe")) != null) {
                result.add(presence);
            }
        }
        return result.size() == 0 ? null : result;
    }

    protected synchronized boolean removeJid(String jid) {
        if (jid == null) {
            return false;
        }
        String bareJid = JIDUtils.getNodeID((String)jid);
        String resource = JIDUtils.getNodeResource((String)jid);
        boolean removed = false;
        if (resource == null) {
            this.resources.remove(bareJid);
        } else {
            Set<String> resources = this.resources.get(bareJid);
            if (resources != null) {
                removed = resources.remove(resource);
                this.log.finest("Contact " + jid + " is removed from collection.");
                if (resources.size() == 0) {
                    this.resources.remove(bareJid);
                }
            }
        }
        return removed;
    }
}

