/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.ElementWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class ManageSubscriptionModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"subscriptions"));

    private static Element createSubscriptionNotification(String fromJid, String toJid, String nodeName, Subscription subscription) {
        Element message = new Element("message", new String[]{"from", "to"}, new String[]{fromJid, toJid});
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        message.addChild((XMLNodeIfc)pubsub);
        Element affilations = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        pubsub.addChild((XMLNodeIfc)affilations);
        affilations.addChild((XMLNodeIfc)new Element("subscription", new String[]{"jid", "subscription"}, new String[]{toJid, subscription.name()}));
        return message;
    }

    public ManageSubscriptionModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#manage-subscriptions"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element, ElementWriter elementWriter) throws PubSubException {
        try {
            UsersAffiliation senderAffiliation;
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element subscriptions = pubsub.getChild("subscriptions");
            String nodeName = subscriptions.getAttribute("node");
            String type = element.getAttribute("type");
            if (type == null || !type.equals("get") && !type.equals("set")) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            String senderJid = element.getAttribute("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            if (type.equals("get")) {
                this.processGet(element, subscriptions, nodeName, nodeSubscriptions, elementWriter);
            } else if (type.equals("set")) {
                this.processSet(element, subscriptions, nodeName, nodeConfig, nodeSubscriptions, elementWriter);
            }
            if (nodeSubscriptions.isChanged()) {
                this.repository.update(nodeName, nodeSubscriptions);
            }
            return null;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void processGet(Element element, Element subscriptions, String nodeName, ISubscriptions nodeSubscriptions, ElementWriter elementWriter) throws RepositoryException {
        Element iq = ManageSubscriptionModule.createResultIQ(element);
        Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
        iq.addChild((XMLNodeIfc)ps);
        Element afr = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        ps.addChild((XMLNodeIfc)afr);
        UsersSubscription[] subscribers = nodeSubscriptions.getSubscriptions();
        if (subscribers != null) {
            for (UsersSubscription usersSubscription : subscribers) {
                if (usersSubscription.getSubscription() == Subscription.none) continue;
                Element subscription = new Element("subscription", new String[]{"jid", "subscription"}, new String[]{usersSubscription.getJid().toString(), usersSubscription.getSubscription().name()});
                afr.addChild((XMLNodeIfc)subscription);
            }
        }
        elementWriter.write(iq);
    }

    private void processSet(Element element, Element subscriptions, String nodeName, AbstractNodeConfig nodeConfig, ISubscriptions nodeSubscriptions, ElementWriter elementWriter) throws PubSubException, RepositoryException {
        Element iq = ManageSubscriptionModule.createResultIQ(element);
        List subss = subscriptions.getChildren();
        for (Element a : subss) {
            if ("subscription".equals(a.getName())) continue;
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        for (Element af : subss) {
            String strSubscription = af.getAttribute("subscription");
            String jid = af.getAttribute("jid");
            if (strSubscription == null) continue;
            Subscription newSubscription = Subscription.valueOf(strSubscription);
            Subscription oldSubscription = nodeSubscriptions.getSubscription(jid);
            Subscription subscription = oldSubscription = oldSubscription == null ? Subscription.none : oldSubscription;
            if (oldSubscription == Subscription.none && newSubscription != Subscription.none) {
                nodeSubscriptions.addSubscriberJid(jid, newSubscription);
                if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
                elementWriter.write(ManageSubscriptionModule.createSubscriptionNotification(element.getAttribute("to"), jid, nodeName, newSubscription));
                continue;
            }
            nodeSubscriptions.changeSubscription(jid, newSubscription);
            if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
            elementWriter.write(ManageSubscriptionModule.createSubscriptionNotification(element.getAttribute("to"), jid, nodeName, newSubscription));
        }
        elementWriter.write(iq);
    }
}

