/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.criteria.Criteria;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.DefaultNodeConfigListener;
import tigase.pubsub.ElementWriter;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.Module;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AdHocConfigCommandModule;
import tigase.pubsub.modules.DefaultConfigModule;
import tigase.pubsub.modules.DiscoverInfoModule;
import tigase.pubsub.modules.DiscoverItemsModule;
import tigase.pubsub.modules.JabberVersionModule;
import tigase.pubsub.modules.ManageAffiliationsModule;
import tigase.pubsub.modules.ManageSubscriptionModule;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.pubsub.modules.NodeCreateModule;
import tigase.pubsub.modules.NodeDeleteModule;
import tigase.pubsub.modules.PendingSubscriptionModule;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.PurgeItemsModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.modules.RetrieveAffiliationsModule;
import tigase.pubsub.modules.RetrieveItemsModule;
import tigase.pubsub.modules.RetrieveSubscriptionsModule;
import tigase.pubsub.modules.SubscribeNodeModule;
import tigase.pubsub.modules.UnsubscribeNodeModule;
import tigase.pubsub.modules.XmppPingModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.modules.commands.DefaultConfigCommand;
import tigase.pubsub.modules.commands.DeleteAllNodesCommand;
import tigase.pubsub.modules.commands.ReadAllNodesCommand;
import tigase.pubsub.modules.commands.RebuildDatabaseCommand;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.PubSubDAOJDBC;
import tigase.pubsub.repository.PubSubDAOPool;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.server.AbstractMessageReceiver;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class PubSubComponent
extends AbstractMessageReceiver
implements XMPPService,
Configurable,
DisableDisco,
DefaultNodeConfigListener {
    public static final String ADMINS_KEY = "admin";
    public static final String DEFAULT_LEAF_NODE_CONFIG_KEY = "default-node-config";
    private static final String MAX_CACHE_SIZE = "pubsub-repository-cache-size";
    protected static final String PUBSUB_REPO_CLASS_PROP_KEY = "pubsub-repo-class";
    protected static final String PUBSUB_REPO_POOL_SIZE_PROP_KEY = "pubsub-repo-pool-size";
    protected static final String PUBSUB_REPO_URL_PROP_KEY = "pubsub-repo-url";
    protected AdHocConfigCommandModule adHocCommandsModule;
    protected final PubSubConfig config = new PubSubConfig();
    protected DefaultConfigModule defaultConfigModule;
    protected LeafNodeConfig defaultNodeConfig;
    protected PubSubDAO directPubSubRepository;
    protected final ElementWriter elementWriter;
    public String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    int lastNodeNo = -1;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected ManageAffiliationsModule manageAffiliationsModule;
    protected ManageSubscriptionModule manageSubscriptionModule;
    private Integer maxRepositoryCacheSize;
    protected final ArrayList<Module> modules = new ArrayList();
    protected NodeConfigModule nodeConfigModule;
    protected NodeCreateModule nodeCreateModule;
    protected NodeDeleteModule nodeDeleteModule;
    protected PendingSubscriptionModule pendingSubscriptionModule;
    protected PresenceCollectorModule presenceCollectorModule;
    protected PublishItemModule publishNodeModule;
    protected CachedPubSubRepository pubsubRepository;
    protected PurgeItemsModule purgeItemsModule;
    protected RetractItemModule retractItemModule;
    protected RetrieveItemsModule retrirveItemsModule;
    protected ServiceEntity serviceEntity;
    protected AbstractModule subscribeNodeModule;
    protected UnsubscribeNodeModule unsubscribeNodeModule;
    protected UserRepository userRepository;
    protected XsltTool xslTransformer;

    public PubSubComponent() {
        this.setName("pubsub");
        this.elementWriter = new ElementWriter(){

            @Override
            public void write(Collection<Element> elements) {
                if (elements != null) {
                    for (Element element : elements) {
                        if (element == null) continue;
                        this.write(element);
                    }
                }
            }

            @Override
            public void write(Element element) {
                if (element != null) {
                    try {
                        PubSubComponent.this.addOutPacket(Packet.packetInstance((Element)element));
                    }
                    catch (TigaseStringprepException ex) {
                        PubSubComponent.this.log.info("Packet addressing problem, stringprep failed: " + element);
                    }
                }
            }
        };
    }

    protected CachedPubSubRepository createPubSubRepository(PubSubDAO directRepository) {
        return new CachedPubSubRepository(directRepository, this.maxRepositoryCacheSize);
    }

    protected String extractNodeName(Element element) {
        if (element == null) {
            return null;
        }
        Element ps = element.getChild("pubsub");
        Element query = element.getChild("query");
        if (ps != null) {
            List children = ps.getChildren();
            if (children != null) {
                for (Element e : children) {
                    String n = e.getAttribute("node");
                    if (n == null) continue;
                    return n;
                }
            }
        } else if (query != null) {
            String n = query.getAttribute("node");
            return n;
        }
        return null;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        String[] hostnames = new String[this.HOSTNAMES_PROP_VAL.length];
        int i = 0;
        for (String host : this.HOSTNAMES_PROP_VAL) {
            hostnames[i++] = this.getName() + "." + host;
        }
        props.put("hostnames", hostnames);
        String repo_class = "tigase.db.jdbc.JDBCRepository";
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        String conf_db = null;
        if (params.get("--user-db") != null) {
            conf_db = (String)params.get("--user-db");
        }
        if (conf_db != null) {
            if (conf_db.equals("mysql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (conf_db.equals("pgsql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
        }
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        props.put(PUBSUB_REPO_CLASS_PROP_KEY, repo_class);
        props.put(PUBSUB_REPO_URL_PROP_KEY, repo_uri);
        props.put(MAX_CACHE_SIZE, "2000");
        String[] admins = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@" + this.getDefHostName()};
        props.put(ADMINS_KEY, admins);
        return props;
    }

    public List<Element> getDiscoFeatures() {
        return null;
    }

    public Element getDiscoInfo(String node, JID jid) {
        return null;
    }

    public List<Element> getDiscoItems(String node, JID jid) {
        if (node == null) {
            Element result = this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid);
            return Arrays.asList(result);
        }
        return null;
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.pubsubRepository.addStats(this.getName(), list);
    }

    public int hashCodeForPacket(Packet packet) {
        List children = packet.getElemChildren("/iq/pubsub");
        if (children != null) {
            for (Element elem : children) {
                String node_name = elem.getAttribute("node");
                if (node_name == null) continue;
                return node_name.hashCode();
            }
        }
        return packet.getFrom().hashCode();
    }

    protected void init() {
        this.xslTransformer = new XsltTool();
        this.presenceCollectorModule = this.registerModule(new PresenceCollectorModule());
        this.publishNodeModule = this.registerModule(new PublishItemModule(this.config, this.pubsubRepository, this.xslTransformer, this.presenceCollectorModule));
        this.retractItemModule = this.registerModule(new RetractItemModule(this.config, this.pubsubRepository, this.publishNodeModule));
        this.pendingSubscriptionModule = this.registerModule(new PendingSubscriptionModule(this.config, this.pubsubRepository));
        this.manageSubscriptionModule = this.registerModule(new ManageSubscriptionModule(this.config, this.pubsubRepository));
        this.subscribeNodeModule = this.registerModule(new SubscribeNodeModule(this.config, this.pubsubRepository, this.pendingSubscriptionModule));
        this.nodeCreateModule = this.registerModule(new NodeCreateModule(this.config, this.pubsubRepository, this.defaultNodeConfig, this.publishNodeModule));
        this.nodeDeleteModule = this.registerModule(new NodeDeleteModule(this.config, this.pubsubRepository, this.publishNodeModule));
        this.defaultConfigModule = this.registerModule(new DefaultConfigModule(this.config, this.pubsubRepository, this.defaultNodeConfig));
        this.nodeConfigModule = this.registerModule(new NodeConfigModule(this.config, this.pubsubRepository, this.defaultNodeConfig, this.publishNodeModule));
        this.unsubscribeNodeModule = this.registerModule(new UnsubscribeNodeModule(this.config, this.pubsubRepository));
        this.manageAffiliationsModule = this.registerModule(new ManageAffiliationsModule(this.config, this.pubsubRepository));
        this.retrirveItemsModule = this.registerModule(new RetrieveItemsModule(this.config, this.pubsubRepository));
        this.purgeItemsModule = this.registerModule(new PurgeItemsModule(this.config, this.pubsubRepository, this.publishNodeModule));
        this.registerModule(new JabberVersionModule());
        this.adHocCommandsModule = this.registerModule(new AdHocConfigCommandModule(this.config, this.pubsubRepository));
        this.registerModule(new DiscoverInfoModule(this.config, this.pubsubRepository, this.modules));
        this.registerModule(new DiscoverItemsModule(this.config, this.pubsubRepository, this.adHocCommandsModule));
        this.registerModule(new RetrieveAffiliationsModule(this.config, this.pubsubRepository));
        this.registerModule(new RetrieveSubscriptionsModule(this.config, this.pubsubRepository));
        this.registerModule(new XmppPingModule());
        this.pubsubRepository.init();
    }

    public void initialize(String[] admins, PubSubDAO pubSubDAO, IPubSubRepository createPubSubRepository, LeafNodeConfig defaultNodeConfig) throws UserNotFoundException, TigaseDBException, RepositoryException {
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Publish-Subscribe");
        this.serviceEntity.addIdentities(new ServiceIdentity[]{new ServiceIdentity("pubsub", "service", "Publish-Subscribe")});
        this.serviceEntity.addFeatures(new String[]{"http://jabber.org/protocol/pubsub"});
        this.config.setAdmins(admins);
        this.config.setServiceName("tigase-pubsub");
        if (pubSubDAO != null) {
            pubSubDAO.init();
        }
        this.directPubSubRepository = pubSubDAO;
        this.pubsubRepository = this.createPubSubRepository(pubSubDAO);
        this.defaultNodeConfig = defaultNodeConfig;
        this.defaultNodeConfig.read(this.userRepository, this.config, DEFAULT_LEAF_NODE_CONFIG_KEY);
        this.defaultNodeConfig.write(this.userRepository, this.config, DEFAULT_LEAF_NODE_CONFIG_KEY);
        this.init();
        DefaultConfigCommand configCommand = new DefaultConfigCommand(this.config, this.userRepository);
        configCommand.addListener(this);
        this.adHocCommandsModule.register(new RebuildDatabaseCommand(this.config, this.directPubSubRepository));
        this.adHocCommandsModule.register(configCommand);
        this.adHocCommandsModule.register(new DeleteAllNodesCommand(this.config, this.directPubSubRepository, this.userRepository));
        this.adHocCommandsModule.register(new ReadAllNodesCommand(this.config, this.directPubSubRepository, this.pubsubRepository));
    }

    public String myDomain() {
        return this.getName() + "." + this.getDefHostName();
    }

    @Override
    public void onChangeDefaultNodeConfig() {
        try {
            this.defaultNodeConfig.read(this.userRepository, this.config, DEFAULT_LEAF_NODE_CONFIG_KEY);
            this.log.info("Node " + this.getComponentId() + " read default node configuration.");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Reading default config error", e);
        }
    }

    public void process(Element element, ElementWriter writer) throws PacketErrorTypeException {
        try {
            boolean handled = this.runModules(element, writer);
            if (!handled) {
                StanzaType type;
                String t = element.getAttribute("type");
                StanzaType stanzaType = type = t == null ? null : StanzaType.valueof((String)t);
                if (type != StanzaType.error) {
                    throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED);
                }
                this.log.finer(element.getName() + " stanza with type='error' ignored");
            }
        }
        catch (PubSubException e) {
            this.log.log(Level.INFO, "Exception thrown for " + element.toString(), e);
            Element result = e.makeElement(element);
            this.log.log(Level.INFO, "Sending back: " + result.toString());
            writer.write(result);
        }
    }

    public int processingThreads() {
        return 1;
    }

    public void processPacket(Packet packet) {
        try {
            this.process(packet.getElement(), this.elementWriter);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unexpected exception: internal-server-error", e);
            e.printStackTrace();
            try {
                this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, e.getMessage(), true));
            }
            catch (PacketErrorTypeException e1) {
                e1.printStackTrace();
                this.log.throwing("PubSub Service", "processPacket (sending internal-server-error)", e);
            }
        }
    }

    public <T extends Module> T registerModule(T module) {
        this.log.config("Register PubSub plugin: " + module.getClass().getCanonicalName());
        this.modules.add(module);
        return module;
    }

    protected boolean runModules(Element element, ElementWriter writer) throws PubSubException {
        boolean handled = false;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finest("Processing packet: " + element.toString());
        }
        for (Module module : this.modules) {
            List<Element> result;
            Criteria criteria = module.getModuleCriteria();
            if (criteria == null || !criteria.match(element)) continue;
            handled = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finest("Handled by module " + module.getClass());
            }
            if ((result = module.process(element, writer)) == null) continue;
            for (Element element2 : result) {
                writer.write(element2);
            }
            return true;
        }
        return handled;
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (this.pubsubRepository != null) {
            this.pubsubRepository.destroy();
        }
        if (this.directPubSubRepository != null) {
            this.directPubSubRepository.destroy();
        }
        this.modules.clear();
        String maxCache = (String)props.get(MAX_CACHE_SIZE);
        if (maxCache != null) {
            try {
                this.maxRepositoryCacheSize = Integer.valueOf(maxCache);
                props.put(MAX_CACHE_SIZE, this.maxRepositoryCacheSize.toString());
            }
            catch (Exception e) {
                this.maxRepositoryCacheSize = null;
                props.put(MAX_CACHE_SIZE, "off");
            }
        }
        this.userRepository = (UserRepository)props.get("shared-user-repo");
        if (this.userRepository == null) {
            this.userRepository = (UserRepository)props.get("shared-user-repo");
        }
        try {
            PubSubDAO dao;
            String cls_name = (String)props.get(PUBSUB_REPO_CLASS_PROP_KEY);
            String res_uri = (String)props.get(PUBSUB_REPO_URL_PROP_KEY);
            if (this.userRepository == null) {
                this.userRepository = RepositoryFactory.getUserRepository((String)cls_name, (String)res_uri, null);
                this.userRepository.initRepository(res_uri, null);
                this.log.config("Initialized " + cls_name + " as pubsub repository: " + res_uri);
            }
            int dao_pool_size = 1;
            try {
                dao_pool_size = Integer.parseInt((String)props.get(PUBSUB_REPO_POOL_SIZE_PROP_KEY));
            }
            catch (Exception e) {
                dao_pool_size = 1;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("PubSubDAO pool size: " + dao_pool_size);
            }
            if (dao_pool_size > 1) {
                PubSubDAOPool dao_pool = new PubSubDAOPool(this.userRepository, this.config);
                for (int i = 0; i < dao_pool_size; ++i) {
                    if (cls_name.equals("tigase.pubsub.repository.PubSubDAOJDBC")) {
                        dao_pool.addDao(new PubSubDAOJDBC(this.userRepository, this.config, res_uri));
                        continue;
                    }
                    dao_pool.addDao(new PubSubDAO(this.userRepository, this.config));
                }
                dao = dao_pool;
            } else {
                dao = cls_name.equals("tigase.pubsub.repository.PubSubDAOJDBC") ? new PubSubDAOJDBC(this.userRepository, this.config, res_uri) : new PubSubDAO(this.userRepository, this.config);
            }
            this.initialize((String[])props.get(ADMINS_KEY), dao, null, new LeafNodeConfig("default"));
        }
        catch (Exception e) {
            this.log.severe("Can't initialize pubsub repository: " + e);
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        for (Module module : this.modules) {
            String[] features = module.getFeatures();
            if (features == null) continue;
            for (String f : features) {
                sb.append(f);
                sb.append('\n');
                this.serviceEntity.addFeatures(new String[]{f});
            }
        }
        this.log.config("Supported features: " + sb.toString());
    }
}

