/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.Module;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public abstract class AbstractModule
implements Module {
    protected final PubSubConfig config;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected final IPubSubRepository repository;

    public static Element createResultIQ(Element iq) {
        Element e = new Element("iq");
        String id = iq.getAttribute("id");
        String from = iq.getAttribute("from");
        String to = iq.getAttribute("to");
        e.addAttribute("type", "result");
        if (to != null) {
            e.addAttribute("from", to);
        }
        if (from != null) {
            e.addAttribute("to", from);
        }
        if (id != null) {
            e.addAttribute("id", id);
        }
        return e;
    }

    public static List<Element> createResultIQArray(Element iq) {
        return AbstractModule.makeArray(AbstractModule.createResultIQ(iq));
    }

    public static List<Element> makeArray(Element ... elements) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (Element element : elements) {
            result.add(element);
        }
        return result;
    }

    public AbstractModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        this.config = config;
        this.repository = pubsubRepository;
    }

    protected String findBestJid(String[] allSubscribers, String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        String best = null;
        for (String j : allSubscribers) {
            if (j.equals(jid)) {
                return j;
            }
            if (!bareJid.equals(j)) continue;
            best = j;
        }
        return best;
    }

    public List<String> getActiveSubscribers(AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers = subscriptions.getSubscriptions();
        if (subscribers == null) {
            return Collections.emptyList();
        }
        String[] jids = new String[subscribers.length];
        for (int i = 0; i < subscribers.length; ++i) {
            jids[i] = subscribers[i].getJid().toString();
        }
        return this.getActiveSubscribers(nodeConfig, jids, affiliations, subscriptions);
    }

    public List<String> getActiveSubscribers(AbstractNodeConfig nodeConfig, String[] jids, IAffiliations affiliations, ISubscriptions subscriptions) {
        ArrayList<String> result = new ArrayList<String>();
        boolean presenceExpired = nodeConfig.isPresenceExpired();
        if (jids != null) {
            for (String jid : jids) {
                Subscription subscription;
                UsersAffiliation affiliation;
                if (presenceExpired) {
                    // empty if block
                }
                if ((affiliation = affiliations.getSubscriberAffiliation(jid)).getAffiliation() == Affiliation.outcast || (subscription = subscriptions.getSubscription(jid)) != Subscription.subscribed) continue;
                result.add(jid);
            }
        }
        return result;
    }

    protected boolean hasSenderSubscription(String jid, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers = subscriptions.getSubscriptions();
        String bareJid = JIDUtils.getNodeID((String)jid);
        for (UsersSubscription owner : subscribers) {
            String[] buddies;
            UsersAffiliation affiliation = affiliations.getSubscriberAffiliation(owner.getJid().toString());
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals(owner)) {
                return true;
            }
            for (String buddy : buddies = this.repository.getUserRoster(owner.getJid())) {
                String s;
                if (!bareJid.equals(buddy) || (s = this.repository.getBuddySubscription(owner.getJid(), bareJid)) == null || !"from".equals(s) && !"both".equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSenderInRosterGroup(String jid, AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers = subscriptions.getSubscriptions();
        String bareJid = JIDUtils.getNodeID((String)jid);
        String[] groupsAllowed = nodeConfig.getRosterGroupsAllowed();
        if (groupsAllowed == null || groupsAllowed.length == 0) {
            return true;
        }
        for (UsersSubscription owner : subscribers) {
            String[] buddies;
            UsersAffiliation affiliation = affiliations.getSubscriberAffiliation(owner.getJid().toString());
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals(owner)) {
                return true;
            }
            for (String buddy : buddies = this.repository.getUserRoster(owner.getJid())) {
                String[] groups;
                if (!bareJid.equals(buddy)) continue;
                for (String group : groups = this.repository.getBuddyGroups(owner.getJid(), bareJid)) {
                    if (!Utils.contain(group, groupsAllowed)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

