/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;

public class Node {
    private boolean deleted = false;
    private long creationTime = System.currentTimeMillis();
    private String name;
    private NodeAffiliations nodeAffiliations;
    private boolean affNeedsWriting = false;
    private AbstractNodeConfig nodeConfig;
    private boolean conNeedsWriting = false;
    private NodeSubscriptions nodeSubscriptions;
    private boolean subNeedsWriting = false;

    public Node(AbstractNodeConfig nodeConfig, NodeAffiliations nodeAffiliations, NodeSubscriptions nodeSubscriptions) {
        this.nodeConfig = nodeConfig;
        this.nodeAffiliations = nodeAffiliations;
        this.nodeSubscriptions = nodeSubscriptions;
        this.name = nodeConfig.getNodeName();
    }

    public String getName() {
        return this.name;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public NodeAffiliations getNodeAffiliations() {
        return this.nodeAffiliations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void affiliationsMerge() {
        Node node = this;
        synchronized (node) {
            this.nodeAffiliations.merge();
            this.affNeedsWriting = true;
        }
    }

    public boolean affiliationsNeedsWriting() {
        return this.affNeedsWriting;
    }

    public void affiliationsSaved() {
        this.affNeedsWriting = false;
    }

    public AbstractNodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configCopyFrom(AbstractNodeConfig nodeConfig) {
        Node node = this;
        synchronized (node) {
            nodeConfig.copyFrom(nodeConfig);
            this.conNeedsWriting = true;
        }
    }

    public boolean configNeedsWriting() {
        return this.conNeedsWriting;
    }

    public void configSaved() {
        this.conNeedsWriting = false;
    }

    public NodeSubscriptions getNodeSubscriptions() {
        return this.nodeSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscriptionsMerge() {
        Node node = this;
        synchronized (node) {
            this.nodeSubscriptions.merge();
            this.subNeedsWriting = true;
        }
    }

    public boolean subscriptionsNeedsWriting() {
        return this.subNeedsWriting;
    }

    public void subscriptionsSaved() {
        this.subNeedsWriting = false;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean needsWriting() {
        return this.subNeedsWriting || this.affNeedsWriting || this.conNeedsWriting;
    }
}

