/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.xml.Element;

public class PubSubDAOPool
extends PubSubDAO {
    private static final Logger log = Logger.getLogger(PubSubDAOPool.class.getName());
    private LinkedBlockingQueue<PubSubDAO> daoPool = new LinkedBlockingQueue();

    public PubSubDAOPool(UserRepository userRepository, PubSubConfig config) {
        super(userRepository, config);
    }

    public void addDao(PubSubDAO dao) {
        this.daoPool.offer(dao);
    }

    public PubSubDAO takeDao() {
        try {
            return this.daoPool.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain PubSub DAO from the pool", ex);
            return null;
        }
    }

    @Override
    public void init() throws RepositoryException {
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNode(String nodeName, String ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.createNode(nodeName, ownerJid, nodeConfig, nodeType, collection);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.deleteNode(nodeName);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(String nodeName, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.writeItem(nodeName, timeInMilis, id, publisher, item);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.deleteItem(nodeName, id);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                String[] stringArray = dao.getItemsIds(nodeName);
                return stringArray;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getItem(String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                Element element = dao.getItem(nodeName, id);
                return element;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getItemCreationDate(String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                Date date = dao.getItemCreationDate(nodeName, id);
                return date;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getItemUpdateDate(String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                Date date = dao.getItemUpdateDate(nodeName, id);
                return date;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeAffiliations getNodeAffiliations(String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                NodeAffiliations nodeAffiliations = dao.getNodeAffiliations(nodeName);
                return nodeAffiliations;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readNodeConfigFormData(String nodeName) throws TigaseDBException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                String string = dao.readNodeConfigFormData(nodeName);
                return string;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNodesList() throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                String[] stringArray = dao.getNodesList();
                return stringArray;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getRootNodes() throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                String[] stringArray = dao.getRootNodes();
                return stringArray;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToRootCollection(String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.addToRootCollection(nodeName);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromRootCollection(String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.removeFromRootCollection(nodeName);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFromRootCollection() throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.removeAllFromRootCollection();
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(String nodeName, String serializedData) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.updateNodeConfig(nodeName, serializedData);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAffiliations(String nodeName, String serializedData) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.updateAffiliations(nodeName, serializedData);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubscriptions(String nodeName, int changedIndex, String serializedData) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.updateSubscriptions(nodeName, changedIndex, serializedData);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSubscriptions getNodeSubscriptions(String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                NodeSubscriptions nodeSubscriptions = dao.getNodeSubscriptions(nodeName);
                return nodeSubscriptions;
            }
            finally {
                this.addDao(dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriptions(String nodeName, int changedIndex) throws RepositoryException {
        PubSubDAO dao = this.takeDao();
        if (dao != null) {
            try {
                dao.removeSubscriptions(nodeName, changedIndex);
            }
            finally {
                this.addDao(dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.daoPool.size());
        }
    }
}

