/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class PubSubDAOJDBC
extends PubSubDAO {
    private String db_conn = null;
    private Connection conn = null;
    private CallableStatement create_node_sp = null;
    private CallableStatement remove_node_sp = null;
    private CallableStatement get_item_sp = null;
    private CallableStatement write_item_sp = null;
    private CallableStatement delete_item_sp = null;
    private CallableStatement get_node_items_ids_sp = null;
    private CallableStatement get_all_nodes_sp = null;
    private CallableStatement delete_all_nodes_sp = null;
    private CallableStatement set_node_configuration_sp = null;
    private CallableStatement set_node_affiliations_sp = null;
    private CallableStatement get_node_configuration_sp = null;
    private CallableStatement get_node_affiliations_sp = null;
    private CallableStatement get_node_subscriptions_sp = null;
    private CallableStatement set_node_subscriptions_sp = null;
    private CallableStatement delete_node_subscriptions_sp = null;
    private PreparedStatement conn_valid_st = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;

    public PubSubDAOJDBC(UserRepository repository, PubSubConfig pubSubConfig, String connection_str) {
        super(repository, pubSubConfig);
        this.db_conn = connection_str;
    }

    private void initPreparedStatements() throws SQLException {
        String query = "select 1";
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "{ call TigPubSubCreateNode(?, ?, ?, ?) }";
        this.create_node_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubRemoveNode(?) }";
        this.remove_node_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetItem(?, ?) }";
        this.get_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubWriteItem(?, ?, ?, ?) }";
        this.write_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteItem(?, ?) }";
        this.delete_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeItemsIds(?) }";
        this.get_node_items_ids_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetAllNodes() }";
        this.get_all_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteAllNodes() }";
        this.delete_all_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeConfiguration(?, ?) }";
        this.set_node_configuration_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeAffiliations(?, ?) }";
        this.set_node_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeConfiguration(?) }";
        this.get_node_configuration_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeAffiliations(?) }";
        this.get_node_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeSubscriptions(?) }";
        this.get_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeSubscriptions(?, ?, ?) }";
        this.set_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteNodeSubscriptions(?, ?) }";
        this.delete_node_subscriptions_sp = this.conn.prepareCall(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            this.conn = DriverManager.getConnection(this.db_conn);
            this.initPreparedStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection() throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    rs = this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
            this.release(null, rs);
        }
        catch (Exception e) {
            this.initRepo();
        }
        finally {
            this.release(null, rs);
        }
        return true;
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public void init() throws RepositoryException {
        try {
            this.initRepo();
        }
        catch (SQLException e) {
            this.conn = null;
            throw new RepositoryException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
        super.init();
    }

    @Override
    public void destroy() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "Problem closing jdbc connection: " + this.db_conn, e);
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createNode(String nodeName, String ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        ResultSet rs = null;
        try {
            String serializedNodeConfig = null;
            if (nodeConfig != null) {
                nodeConfig.setNodeType(nodeType);
                serializedNodeConfig = nodeConfig.getFormElement().toString();
            }
            this.checkConnection();
            CallableStatement callableStatement = this.create_node_sp;
            synchronized (callableStatement) {
                this.create_node_sp.setString(1, nodeName);
                this.create_node_sp.setInt(2, nodeType.ordinal());
                this.create_node_sp.setString(3, JIDUtils.getNodeID((String)ownerJid));
                this.create_node_sp.setString(4, serializedNodeConfig);
                rs = this.create_node_sp.executeQuery();
            }
            this.release(null, rs);
            return;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new RepositoryException("Error while adding node to repository, already exists?", e);
                catch (SQLException e2) {
                    e2.printStackTrace();
                    throw new RepositoryException("Problem accessing repository.", e2);
                }
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(String nodeName) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.remove_node_sp;
            synchronized (callableStatement) {
                this.remove_node_sp.setString(1, nodeName);
                this.remove_node_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node deleting error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(String nodeName, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.write_item_sp;
            synchronized (callableStatement) {
                this.write_item_sp.setString(1, nodeName);
                this.write_item_sp.setString(2, id);
                this.write_item_sp.setString(3, publisher);
                this.write_item_sp.setString(4, item.toString());
                rs = this.write_item_sp.executeQuery();
            }
            this.release(null, rs);
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("Item writing error", e);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(String nodeName, String id) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_item_sp;
            synchronized (callableStatement) {
                this.delete_item_sp.setString(1, nodeName);
                this.delete_item_sp.setString(2, id);
                this.delete_item_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item removing error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(String nodeName) throws RepositoryException {
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_items_ids_sp;
        synchronized (callableStatement) {
            try {
                this.get_node_items_ids_sp.setString(1, nodeName);
                rs = this.get_node_items_ids_sp.executeQuery();
                ArrayList<String> ids = new ArrayList<String>();
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                String[] stringArray = ids.toArray(new String[0]);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                this.release(null, rs);
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Items list reading error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public Element getItem(String nodeName, String id) throws RepositoryException {
        return this.itemDataToElement(this.getStringFromItem(nodeName, id, 1).toCharArray());
    }

    @Override
    public String getItemPublisher(String nodeName, String id) throws RepositoryException {
        return this.getStringFromItem(nodeName, id, 2);
    }

    @Override
    public Date getItemCreationDate(String nodeName, String id) throws RepositoryException {
        return this.getDateFromItem(nodeName, id, 3);
    }

    @Override
    public Date getItemUpdateDate(String nodeName, String id) throws RepositoryException {
        return this.getDateFromItem(nodeName, id, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getStringFromItem(String nodeName, String id, int field) throws RepositoryException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            CallableStatement callableStatement = this.get_item_sp;
            synchronized (callableStatement) {
                this.get_item_sp.setString(1, nodeName);
                this.get_item_sp.setString(2, id);
                rs = this.get_item_sp.executeQuery();
                if (rs.next()) {
                    String string2 = rs.getString(field);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var5_5
                    this.release(null, rs);
                    return string2;
                }
                string = null;
            }
            this.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Item field " + field + " reading error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Date getDateFromItem(String nodeName, String id, int field) throws RepositoryException {
        ResultSet rs = null;
        try {
            Date date;
            this.checkConnection();
            CallableStatement callableStatement = this.get_item_sp;
            synchronized (callableStatement) {
                this.get_item_sp.setString(1, nodeName);
                this.get_item_sp.setString(2, id);
                rs = this.get_item_sp.executeQuery();
                if (rs.next()) {
                    String date2 = rs.getString(field);
                    if (date2 == null) {
                        Date date3 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 10, 11] lbl14 : MonitorExitStatement: MONITOREXIT : var5_5
                        this.release(null, rs);
                        return date3;
                    }
                    Date date4 = DateFormat.getDateInstance().parse(date2);
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 11] lbl18 : MonitorExitStatement: MONITOREXIT : var5_5
                    this.release(null, rs);
                    return date4;
                }
                date = null;
            }
            this.release(null, rs);
            return date;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Item field " + field + " reading error", e);
            }
            catch (ParseException e) {
                throw new RepositoryException("Item field " + field + " parsing error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeAffiliations getNodeAffiliations(String nodeName) throws RepositoryException {
        ResultSet rs = null;
        try {
            NodeAffiliations nodeAffiliations;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_affiliations_sp;
            synchronized (callableStatement) {
                this.get_node_affiliations_sp.setString(1, nodeName);
                rs = this.get_node_affiliations_sp.executeQuery();
                if (rs.next()) {
                    NodeAffiliations nodeAffiliations2 = NodeAffiliations.create(rs.getString(1));
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.release(null, rs);
                    return nodeAffiliations2;
                }
                nodeAffiliations = null;
            }
            this.release(null, rs);
            return nodeAffiliations;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Node subscribers reading error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String readNodeConfigFormData(String nodeName) throws TigaseDBException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_configuration_sp;
            synchronized (callableStatement) {
                this.get_node_configuration_sp.setString(1, nodeName);
                rs = this.get_node_configuration_sp.executeQuery();
                if (rs.next()) {
                    String string2 = rs.getString(1);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.release(null, rs);
                    return string2;
                }
                string = null;
            }
            this.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new TigaseDBException("Node subscribers reading error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNodesList() throws RepositoryException {
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_all_nodes_sp;
        synchronized (callableStatement) {
            try {
                rs = this.get_all_nodes_sp.executeQuery();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                String[] stringArray = names.toArray(new String[0]);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                this.release(null, rs);
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Nodes list getting error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public String[] getRootNodes() throws RepositoryException {
        return this.getNodesList();
    }

    @Override
    public void addToRootCollection(String nodeName) throws RepositoryException {
    }

    @Override
    public void removeFromRootCollection(String nodeName) throws RepositoryException {
        this.deleteNode(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFromRootCollection() throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_all_nodes_sp;
            synchronized (callableStatement) {
                this.delete_all_nodes_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Removing root collection error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(String nodeName, String serializedData) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_configuration_sp;
            synchronized (callableStatement) {
                this.set_node_configuration_sp.setString(1, nodeName);
                this.set_node_configuration_sp.setString(2, serializedData);
                rs = this.set_node_configuration_sp.executeQuery();
            }
            this.release(null, rs);
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("Node configuration writing error", e);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAffiliations(String nodeName, String serializedData) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_affiliations_sp;
            synchronized (callableStatement) {
                this.set_node_affiliations_sp.setString(1, nodeName);
                this.set_node_affiliations_sp.setString(2, serializedData);
                rs = this.set_node_affiliations_sp.executeQuery();
            }
            this.release(null, rs);
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("Node subscribers writing error", e);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubscriptions(String nodeName, int changedIndex, String serializedData) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_subscriptions_sp;
            synchronized (callableStatement) {
                this.set_node_subscriptions_sp.setString(1, nodeName);
                this.set_node_subscriptions_sp.setInt(2, changedIndex);
                this.set_node_subscriptions_sp.setString(3, serializedData);
                rs = this.set_node_subscriptions_sp.executeQuery();
            }
            this.release(null, rs);
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("Node subscribers writing error", e);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSubscriptions getNodeSubscriptions(String nodeName) throws RepositoryException {
        ResultSet rs = null;
        NodeSubscriptions ns = NodeSubscriptions.create();
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_subscriptions_sp;
        synchronized (callableStatement) {
            try {
                this.get_node_subscriptions_sp.setString(1, nodeName);
                rs = this.get_node_subscriptions_sp.executeQuery();
                while (rs.next()) {
                    ns.parse(rs.getString(1));
                }
                NodeSubscriptions nodeSubscriptions = ns;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var4_5
                this.release(null, rs);
                return nodeSubscriptions;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Node subscribers reading error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriptions(String nodeName, int changedIndex) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_node_subscriptions_sp;
            synchronized (callableStatement) {
                this.delete_node_subscriptions_sp.setString(1, nodeName);
                this.delete_node_subscriptions_sp.setInt(2, changedIndex);
                this.delete_node_subscriptions_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers fragment removing error", e);
        }
    }
}

