/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.ArrayList;
import java.util.logging.Logger;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdhHocRequest;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.pubsub.DefaultNodeConfigListener;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class DefaultConfigCommand
implements AdHocCommand {
    private final PubSubConfig config;
    private final ArrayList<DefaultNodeConfigListener> listener = new ArrayList();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final UserRepository userRepository;

    public DefaultConfigCommand(PubSubConfig config, UserRepository userRepository) {
        this.config = config;
        this.userRepository = userRepository;
    }

    public void addListener(DefaultNodeConfigListener listener) {
        this.listener.add(listener);
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)request.getSender()))) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                LeafNodeConfig defaultNodeConfig = new LeafNodeConfig("default");
                defaultNodeConfig.read(this.userRepository, this.config, "default-node-config");
                response.getElements().add(defaultNodeConfig.getFormElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    LeafNodeConfig nodeConfig = new LeafNodeConfig("default");
                    nodeConfig.read(this.userRepository, this.config, "default-node-config");
                    NodeConfigModule.parseConf(nodeConfig, request.getCommand());
                    nodeConfig.write(this.userRepository, this.config, "default-node-config");
                    this.fireOnChangeDefaultNodeConfig();
                    Form f = new Form(null, "Info", "Default config saved.");
                    response.getElements().add(f.getElement());
                    response.completeSession();
                }
                response.completeSession();
            }
        }
        catch (AdHocCommandException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    protected void fireOnChangeDefaultNodeConfig() {
        for (DefaultNodeConfigListener listener : this.listener) {
            listener.onChangeDefaultNodeConfig();
        }
    }

    @Override
    public String getName() {
        return "Default config";
    }

    @Override
    public String getNode() {
        return "default-config";
    }

    public void removeListener(DefaultNodeConfigListener listener) {
        this.listener.remove(listener);
    }
}

