/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusteredComponent;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.ListCache;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.cluster.ClusterNodeMap;
import tigase.pubsub.cluster.Command;
import tigase.pubsub.cluster.ViewNodeLoadCommand;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class PubSubClusterComponent
extends PubSubComponent
implements ClusteredComponent {
    private static final String METHOD_PRESENCE_COLLECTION = "pubsub.presenceCollection";
    private static final String METHOD_RESULT = "pubsub.result";
    private static final String METHOD_SET_OWNERSHIP = "pubsub.setOwnership";
    private final Set<String> cluster_nodes = new LinkedHashSet<String>();
    protected final ClusterNodeMap nodeMap;
    protected final ListCache<String, Command> waitingsCommands = new ListCache(1000, 60000L);

    protected static String[] getParameters(String name, Map<String, String> allMethodParams) {
        ArrayList<String> nodesNames = new ArrayList<String>();
        for (Map.Entry<String, String> pps : allMethodParams.entrySet()) {
            if (!pps.getKey().startsWith(name)) continue;
            nodesNames.add(pps.getValue());
        }
        return nodesNames.toArray(new String[0]);
    }

    public PubSubClusterComponent() {
        this.log = Logger.getLogger(this.getClass().getName());
        this.log.config("PubSubCluster Component starting");
        this.nodeMap = new ClusterNodeMap(this.cluster_nodes);
    }

    private String findNextUnvisitedNode(ClusterElement clel) {
        String comp_id = this.getComponentId();
        if (this.cluster_nodes.size() > 0) {
            String next_node = null;
            for (String cluster_node : this.cluster_nodes) {
                if (clel.isVisitedNode(cluster_node) || cluster_node.equals(comp_id)) continue;
                next_node = cluster_node;
                this.log.finest("Found next cluster node: " + next_node);
                break;
            }
            return next_node;
        }
        return null;
    }

    public String getComponentId() {
        String name = System.getProperty("test", "no").equals("yes") ? super.getComponentId().replace("@", ".") : super.getComponentId();
        return name;
    }

    protected String getFirstClusterNode() {
        String cluster_node = null;
        for (String node : this.cluster_nodes) {
            if (node.equals(this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }

    @Override
    protected void init() {
        if (System.getProperty("test", "no").equals("yes")) {
            HashSet<String> n = new HashSet<String>();
            n.add("pubsub.sphere");
            n.add("pubsub1.sphere");
            n.add("pubsub2.sphere");
            String msh = "********** !!!  TEST ENVIROMENT !!! **********";
            System.out.println("********** !!!  TEST ENVIROMENT !!! **********");
            this.log.config("********** !!!  TEST ENVIROMENT !!! **********");
            for (String string : n) {
                this.log.config("Test Node connected: " + string);
                this.cluster_nodes.add(string);
            }
        }
        super.init();
        this.log.config("PubSubCluster component configured.");
    }

    @Override
    public void initialize(String[] admins, PubSubDAO pubSubDAO, IPubSubRepository createPubSubRepository, LeafNodeConfig defaultNodeConfig) throws UserNotFoundException, TigaseDBException, RepositoryException {
        super.initialize(admins, pubSubDAO, createPubSubRepository, defaultNodeConfig);
        this.log.info(this.getComponentId() + " reads all nodes");
        String[] nodes = this.directPubSubRepository.getNodesList();
        this.nodeMap.addPubSubNode(nodes);
        this.adHocCommandsModule.register(new ViewNodeLoadCommand(this.config, this.nodeMap));
    }

    private boolean isProcessedLocally(String node) {
        if (this.publishNodeModule.isPEPNodeName(node)) {
            return true;
        }
        return "http://jabber.org/protocol/commands".equals(node);
    }

    public void nodesConnected(Set<String> node_hostnames) {
        for (String node : node_hostnames) {
            this.log.finest("Node connected: " + node + " (" + this.getName() + "@" + node + ")");
            this.cluster_nodes.add(this.getName() + "@" + node);
            this.sendAvailableJidsToNode(this.getName() + "@" + node);
        }
    }

    public void nodesDisconnected(Set<String> node_hostnames) {
        for (String node : node_hostnames) {
            this.log.finest("Node disconnected: " + node + " (" + this.getName() + "@" + node + ")");
            this.cluster_nodes.remove(this.getName() + "@" + node);
        }
    }

    protected void processMethodCall(ClusterElement clel) throws RepositoryException, PacketErrorTypeException {
        String methodName = clel.getMethodName();
        Map methodParams = clel.getAllMethodParams();
        String uuid = (String)methodParams.get("uuid");
        if (clel.getFirstNode().equals(this.getComponentId())) {
            Command command = (Command)this.waitingsCommands.remove(uuid);
            if (command != null) {
                command.execute();
            }
        } else if (METHOD_PRESENCE_COLLECTION.equals(methodName)) {
            String[] jids;
            for (String jid : jids = PubSubClusterComponent.getParameters("jid", methodParams)) {
                this.presenceCollectorModule.addJid(jid);
            }
        } else if (METHOD_SET_OWNERSHIP.equals(methodName)) {
            String clusterNode = (String)methodParams.get("clusterNodeId");
            String pubsubNode = (String)methodParams.get("pubsubNodeName");
            this.nodeMap.assign(clusterNode, pubsubNode);
            boolean sent = this.sentToNextNode(clel);
        } else {
            throw new RuntimeException("Unsupported method " + methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPacket(final Packet packet) {
        this.log.finest("Received by " + this.getComponentId() + ": " + packet.getElement().toString());
        if (packet.getElemName() == "cluster" || packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            this.log.finest("Handling as internal cluster message");
            ClusterElement clel = new ClusterElement(packet.getElement());
            List elements = clel.getDataPackets();
            if (clel.getMethodName() != null) {
                try {
                    this.processMethodCall(clel);
                }
                catch (Exception e) {
                    this.log.throwing("PubSub Service", "processPacket (remote method call)", e);
                    e.printStackTrace();
                    try {
                        this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, e.getMessage(), true));
                    }
                    catch (PacketErrorTypeException e1) {
                        e1.printStackTrace();
                        this.log.throwing("PubSub Service", "processPacket (sending internal-server-error)", e);
                    }
                }
            } else {
                for (Element element : elements) {
                    super.processPacket(new Packet(element));
                }
            }
        } else if (this.cluster_nodes == null || this.cluster_nodes.size() == 0) {
            super.processPacket(packet);
        } else {
            Element element = packet.getElement();
            if (element.getName().equals("presence")) {
                this.sentBroadcast(packet);
            } else {
                String node = this.extractNodeName(element);
                if (node != null) {
                    if (this.isProcessedLocally(node)) {
                        super.processPacket(packet);
                    } else {
                        String clusterNode = this.nodeMap.getClusterNodeId(node);
                        if (clusterNode == null) {
                            PubSubClusterComponent pubSubClusterComponent = this;
                            synchronized (pubSubClusterComponent) {
                                clusterNode = this.nodeMap.getNewOwnerOfNode(node);
                                String uuid = UUID.randomUUID().toString();
                                this.nodeMap.assign(clusterNode, node);
                                final String n = clusterNode;
                                this.waitingsCommands.put(uuid, new Command(){

                                    @Override
                                    public void execute() {
                                        PubSubClusterComponent.this.sentToNode(packet, n);
                                    }
                                });
                                this.sendOwnershipInformation(uuid, clusterNode, node);
                            }
                        } else {
                            this.log.finest("Cluster node " + this.getComponentId() + " received PubSub node '" + node + "' and sent it to cluster node [" + clusterNode + "]");
                            this.sentToNode(packet, clusterNode);
                        }
                    }
                } else {
                    this.log.finest("Cluster node " + this.getComponentId() + " received stanza without node name");
                    super.processPacket(packet);
                }
            }
        }
    }

    protected void sendAvailableJidsToNode(String node) {
        HashMap<String, String> params = new HashMap<String, String>();
        int counter = 0;
        for (String jid : this.presenceCollectorModule.getAllAvailableJids()) {
            params.put("jid." + ++counter, jid);
            if (params.size() <= 99) continue;
            ClusterElement call = ClusterElement.createClusterMethodCall((String)this.getComponentId(), (String)node, (StanzaType)StanzaType.set, (String)METHOD_PRESENCE_COLLECTION, params);
            this.addOutPacket(new Packet(call.getClusterElement()));
            params = new HashMap();
        }
        if (params.size() != 0) {
            ClusterElement call = ClusterElement.createClusterMethodCall((String)this.getComponentId(), (String)node, (StanzaType)StanzaType.set, (String)METHOD_PRESENCE_COLLECTION, params);
            this.addOutPacket(new Packet(call.getClusterElement()));
        }
    }

    private void sendOwnershipInformation(String uuid, String clusterNode, String pubsubNode) {
        String cluster_node = this.getFirstClusterNode();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uuid);
        params.put("clusterNodeId", clusterNode);
        params.put("pubsubNodeName", pubsubNode);
        ClusterElement call = ClusterElement.createClusterMethodCall((String)this.getComponentId(), (String)cluster_node, (StanzaType)StanzaType.set, (String)METHOD_SET_OWNERSHIP, params);
        this.sentToNextNode(call);
    }

    private void sendResult(String firstNode, String uuid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uuid);
        ClusterElement call = ClusterElement.createClusterMethodCall((String)this.getComponentId(), (String)firstNode, (StanzaType)StanzaType.result, (String)METHOD_RESULT, params);
        this.addOutPacket(new Packet(call.getClusterElement()));
    }

    protected void sentBroadcast(Packet packet) {
        this.log.finest("Send broadcast with: " + packet.toString());
        for (String cNN : this.cluster_nodes) {
            this.sentToNode(packet, cNN);
        }
    }

    protected boolean sentToNextNode(ClusterElement clel) {
        ClusterElement next_clel = ClusterElement.createForNextNode((ClusterElement)clel, (String[])this.cluster_nodes.toArray(new String[this.cluster_nodes.size()]), (String)this.getComponentId());
        if (next_clel != null) {
            next_clel.addVisitedNode(this.getComponentId());
            this.addOutPacket(new Packet(next_clel.getClusterElement()));
            return true;
        }
        return false;
    }

    protected boolean sentToNextNode(Packet packet) {
        if (this.cluster_nodes.size() > 0) {
            String sess_man_id = this.getComponentId();
            String cluster_node = this.getFirstClusterNode();
            if (cluster_node != null) {
                ClusterElement clel = new ClusterElement(sess_man_id, cluster_node, StanzaType.set, packet);
                clel.addVisitedNode(sess_man_id);
                this.log.finest("Sending packet to next node [" + cluster_node + "]");
                this.addOutPacket(new Packet(clel.getClusterElement()));
                return true;
            }
        }
        return false;
    }

    protected boolean sentToNode(Packet packet, String cluster_node) {
        if (cluster_node.equals(this.getComponentId())) {
            super.processPacket(packet);
        } else if (this.cluster_nodes.size() > 0) {
            String sess_man_id = this.getComponentId();
            if (cluster_node != null) {
                ClusterElement clel = new ClusterElement(sess_man_id, cluster_node, StanzaType.set, packet);
                clel.addVisitedNode(sess_man_id);
                this.log.finest("Sending packet to next node [" + cluster_node + "]");
                this.addOutPacket(new Packet(clel.getClusterElement()));
                return true;
            }
        }
        return false;
    }
}

