/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.JIDUtils;

class NodeSubscriptions
extends tigase.pubsub.repository.NodeSubscriptions {
    protected final Map<String, UsersSubscription> changedSubs = new HashMap<String, UsersSubscription>();

    private NodeSubscriptions() {
    }

    public NodeSubscriptions(tigase.pubsub.repository.NodeSubscriptions nodeSubscriptions) {
        this.subs.putAll(nodeSubscriptions.getSubscriptionsMap());
    }

    @Override
    public String addSubscriberJid(String jid, Subscription subscription) {
        String subid = Utils.createUID();
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        this.changedSubs.put(bareJid, s);
        return subid;
    }

    @Override
    public void changeSubscription(String jid, Subscription subscription) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = (UsersSubscription)this.subs.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
            this.changedSubs.put(s.getJid(), s);
        }
    }

    @Override
    protected UsersSubscription get(String bareJid) {
        UsersSubscription us = this.changedSubs.get(bareJid);
        if (us == null && (us = (UsersSubscription)this.subs.get(bareJid)) != null) {
            try {
                return us.clone();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return us;
    }

    @Override
    public UsersSubscription[] getSubscriptions() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.subs.getAllValues());
        result.addAll(this.changedSubs.values());
        return result.toArray(new UsersSubscription[0]);
    }

    @Override
    public boolean isChanged() {
        return this.changedSubs.size() > 0;
    }

    public void merge() {
        this.subs.putAll(this.changedSubs);
        this.changedSubs.clear();
    }

    @Override
    public void resetChangedFlag() {
        this.changedSubs.clear();
    }
}

