/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.Items;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.FragmentedMap;
import tigase.stats.StatRecord;

public class CachedPubSubRepository
implements IPubSubRepository {
    public static final long MAX_WRITE_DELAY = 15000L;
    private final PubSubDAO dao;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final Integer maxCacheSize;
    private final Map<String, Node> nodes;
    private final ConcurrentSkipListSet<Node> nodesToSave = new ConcurrentSkipListSet<Node>(new NodeComparator());
    private final Set<String> rootCollection = new HashSet<String>();
    private LazyWriteThread tlazyWriteThread;

    public CachedPubSubRepository(PubSubDAO dao, Integer maxCacheSize) {
        this.dao = dao;
        this.maxCacheSize = maxCacheSize;
        this.nodes = Collections.synchronizedMap(new SizedCache(this.maxCacheSize));
        this.log.config("Initializing Cached Repository with cache size = " + (maxCacheSize == null ? "OFF" : maxCacheSize));
        this.tlazyWriteThread = this.makeLazyWriteThread(false);
        Thread x = new Thread(this.tlazyWriteThread);
        x.setName("PubSub-DataWriter");
        x.setDaemon(true);
        x.start();
    }

    public void addStats(String name, List<StatRecord> stats) {
        stats.add(new StatRecord(name, "Cached nodes", "long", this.nodes.size(), Level.INFO));
        stats.add(new StatRecord(name, "Unsaved nodes", "long", this.nodesToSave.size(), Level.INFO));
        long subscriptionsCount = 0L;
        long affiliationsCount = 0L;
        LinkedHashMap<String, Node> tmp = new LinkedHashMap<String, Node>(this.nodes);
        for (Node nd : tmp.values()) {
            subscriptionsCount += (long)nd.getNodeSubscriptions().getSubscriptionsMap().size();
            affiliationsCount += (long)nd.getNodeAffiliations().getAffiliationsMap().size();
        }
        stats.add(new StatRecord(name, "Subscriptions count (in cache)", "long", subscriptionsCount, Level.INFO));
        stats.add(new StatRecord(name, "Affiliations count (in cache)", "long", affiliationsCount, Level.INFO));
    }

    @Override
    public void addToRootCollection(String nodeName) throws RepositoryException {
        this.dao.addToRootCollection(nodeName);
        this.rootCollection.add(nodeName);
    }

    @Override
    public void createNode(String nodeName, String ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        this.dao.createNode(nodeName, ownerJid, nodeConfig, nodeType, collection);
        NodeAffiliations nodeAffiliations = new NodeAffiliations(NodeAffiliations.create(null));
        NodeSubscriptions nodeSubscriptions = new NodeSubscriptions(NodeSubscriptions.create());
        Node node = new Node(nodeConfig, nodeAffiliations, nodeSubscriptions);
        this.nodes.put(nodeName, node);
    }

    @Override
    public void deleteNode(String nodeName) throws RepositoryException {
        Node node = this.nodes.get(nodeName);
        this.dao.deleteNode(nodeName);
        if (node != null) {
            node.setDeleted(true);
        }
        this.nodes.remove(nodeName);
    }

    @Override
    public void forgetConfiguration(String nodeName) throws RepositoryException {
        this.nodes.remove(nodeName);
    }

    @Override
    public String[] getBuddyGroups(String owner, String bareJid) throws RepositoryException {
        return this.dao.getBuddyGroups(owner, bareJid);
    }

    @Override
    public String getBuddySubscription(String owner, String buddy) throws RepositoryException {
        return this.dao.getBuddySubscription(owner, buddy);
    }

    private Node getNode(String nodeName) throws RepositoryException {
        Node node = this.nodes.get(nodeName);
        if (node == null) {
            AbstractNodeConfig nodeConfig = this.dao.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                return null;
            }
            NodeAffiliations nodeAffiliations = new NodeAffiliations(this.dao.getNodeAffiliations(nodeName));
            NodeSubscriptions nodeSubscriptions = new NodeSubscriptions(this.dao.getNodeSubscriptions(nodeName));
            node = new Node(nodeConfig, nodeAffiliations, nodeSubscriptions);
            this.nodes.put(nodeName, node);
        }
        return node;
    }

    @Override
    public IAffiliations getNodeAffiliations(String nodeName) throws RepositoryException {
        Node node = this.getNode(nodeName);
        return node == null ? null : node.getNodeAffiliations();
    }

    @Override
    public AbstractNodeConfig getNodeConfig(String nodeName) throws RepositoryException {
        Node node = this.getNode(nodeName);
        try {
            return node == null ? null : node.getNodeConfig().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IItems getNodeItems(String nodeName) throws RepositoryException {
        return new Items(nodeName, this.dao);
    }

    @Override
    public ISubscriptions getNodeSubscriptions(String nodeName) throws RepositoryException {
        Node node = this.getNode(nodeName);
        return node == null ? null : node.getNodeSubscriptions();
    }

    @Override
    public IPubSubDAO getPubSubDAO() {
        return this.dao;
    }

    @Override
    public String[] getRootCollection() throws RepositoryException {
        String[] x;
        if (this.rootCollection.size() == 0 && (x = this.dao.getRootNodes()) != null) {
            for (String string : x) {
                this.rootCollection.add(string);
            }
        }
        return this.rootCollection.toArray(new String[this.rootCollection.size()]);
    }

    @Override
    public String[] getUserRoster(String owner) throws RepositoryException {
        return this.dao.getUserRoster(owner);
    }

    @Override
    public void init() {
        this.log.config("Cached PubSubRepository initialising...");
    }

    @Override
    public void destroy() {
        this.tlazyWriteThread.stop();
    }

    private LazyWriteThread makeLazyWriteThread(boolean immediatelly) {
        return new LazyWriteThread();
    }

    @Override
    public void removeFromRootCollection(String nodeName) throws RepositoryException {
        this.dao.removeFromRootCollection(nodeName);
        this.rootCollection.remove(nodeName);
    }

    @Override
    public void update(String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        Node node = this.getNode(nodeName);
        if (node != null) {
            node.configCopyFrom(nodeConfig);
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (config)");
            this.nodesToSave.add(node);
            this.tlazyWriteThread.wakeup();
        }
    }

    @Override
    public void update(String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        if (nodeAffiliations instanceof NodeAffiliations) {
            NodeAffiliations affiliations = (NodeAffiliations)nodeAffiliations;
            Node node = this.getNode(nodeName);
            if (node != null) {
                if (node.getNodeAffiliations() != nodeAffiliations) {
                    throw new RuntimeException("INCORRECT");
                }
                node.affiliationsMerge();
                this.log.finest("Node '" + nodeName + "' added to lazy write queue (affiliations)");
                this.nodesToSave.add(node);
                this.tlazyWriteThread.wakeup();
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    @Override
    public void update(String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        if (nodeSubscriptions instanceof NodeSubscriptions) {
            NodeSubscriptions subscriptions = (NodeSubscriptions)nodeSubscriptions;
            Node node = this.getNode(nodeName);
            if (node != null) {
                if (node.getNodeSubscriptions() != nodeSubscriptions) {
                    throw new RuntimeException("INCORRECT");
                }
                node.subscriptionsMerge();
                this.log.finest("Node '" + nodeName + "' added to lazy write queue (subscriptions)");
                this.nodesToSave.add(node);
                this.tlazyWriteThread.wakeup();
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    private class SizedCache
    extends LinkedHashMap<String, Node> {
        private static final long serialVersionUID = 1L;
        private int maxCacheSize;

        public SizedCache(int maxSize) {
            super(maxSize, 0.1f, true);
            this.maxCacheSize = 1000;
            this.maxCacheSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Node> eldest) {
            return this.size() > this.maxCacheSize && !eldest.getValue().needsWriting();
        }
    }

    private class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getCreationTime() < o2.getCreationTime()) {
                return -1;
            }
            if (o1.getCreationTime() > o2.getCreationTime()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class LazyWriteThread
    implements Runnable {
        private boolean stop = false;

        public void stop() {
            CachedPubSubRepository.this.log.info("Stopping LazyWriteThread...");
            this.stop = true;
            this.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            ConcurrentSkipListSet concurrentSkipListSet = CachedPubSubRepository.this.nodesToSave;
            synchronized (concurrentSkipListSet) {
                CachedPubSubRepository.this.nodesToSave.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CachedPubSubRepository.this.log.info("Started new LazyWriteThread.");
            while (!this.stop || CachedPubSubRepository.this.nodesToSave.size() > 0) {
                Object object;
                Node node = (Node)CachedPubSubRepository.this.nodesToSave.pollFirst();
                if (node != null) {
                    object = node;
                    synchronized (object) {
                        try {
                            if (node.isDeleted()) {
                                continue;
                            }
                            if (node.affiliationsNeedsWriting()) {
                                CachedPubSubRepository.this.dao.updateAffiliations(node.getName(), node.getNodeAffiliations().serialize());
                                node.affiliationsSaved();
                            }
                            if (node.subscriptionsNeedsWriting()) {
                                FragmentedMap<String, UsersSubscription> fm = node.getNodeSubscriptions().getFragmentedMap();
                                fm.defragment();
                                for (Integer deletedIndex : fm.getRemovedFragmentIndexes()) {
                                    CachedPubSubRepository.this.dao.removeSubscriptions(node.getName(), deletedIndex);
                                }
                                for (Integer changedIndex : fm.getChangedFragmentIndexes()) {
                                    Map<String, UsersSubscription> ft = fm.getFragment(changedIndex);
                                    CachedPubSubRepository.this.dao.updateSubscriptions(node.getName(), changedIndex, node.getNodeSubscriptions().serialize(ft));
                                }
                                fm.cleanChangingLog();
                                node.subscriptionsSaved();
                            }
                            if (node.configNeedsWriting()) {
                                CachedPubSubRepository.this.dao.updateNodeConfig(node.getName(), node.getNodeConfig().getFormElement().toString());
                                node.configSaved();
                            }
                        }
                        catch (Exception e) {
                            CachedPubSubRepository.this.log.log(Level.WARNING, "Problem saving pubsub data: ", e);
                        }
                        if (node.needsWriting()) {
                            CachedPubSubRepository.this.nodesToSave.add(node);
                        }
                        continue;
                    }
                }
                if (this.stop) continue;
                try {
                    object = CachedPubSubRepository.this.nodesToSave;
                    synchronized (object) {
                        CachedPubSubRepository.this.nodesToSave.wait();
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            CachedPubSubRepository.this.log.info("Stopped LazyWriteThread...");
        }
    }
}

