/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class PubSubDAO
implements IPubSubDAO {
    public static final String CREATION_DATE_KEY = "creation-date";
    private static final String ITEMS_KEY = "items";
    public static final String NODES_KEY = "nodes/";
    private static final String ROOT_COLLECTION_KEY = "root-collection";
    final PubSubConfig config;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    final UserRepository repository;

    public PubSubDAO(UserRepository repository, PubSubConfig pubSubConfig) {
        this.repository = repository;
        this.config = pubSubConfig;
    }

    @Override
    public void addToRootCollection(String nodeName) throws RepositoryException {
        try {
            this.repository.setData(this.config.getServiceName(), ROOT_COLLECTION_KEY, nodeName, "root");
        }
        catch (Exception e) {
            throw new RepositoryException("Adding to root collection error", e);
        }
    }

    @Override
    public void createNode(String nodeName, String ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        try {
            nodeConfig.setNodeType(nodeType);
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, CREATION_DATE_KEY, String.valueOf(System.currentTimeMillis()));
            if (nodeConfig != null) {
                this.update(nodeName, nodeConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Node creation error", e);
        }
    }

    @Override
    public void deleteItem(String nodeName, String id) throws RepositoryException {
        try {
            this.repository.removeSubnode(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id);
        }
        catch (Exception e) {
            throw new RepositoryException("Item removing error", e);
        }
    }

    @Override
    public void deleteNode(String nodeName) throws RepositoryException {
        try {
            this.repository.removeSubnode(this.config.getServiceName(), NODES_KEY + nodeName);
        }
        catch (Exception e) {
            throw new RepositoryException("Node deleting error", e);
        }
    }

    @Override
    public String[] getBuddyGroups(String owner, String buddy) throws RepositoryException {
        try {
            return this.repository.getDataList(owner, "roster/" + buddy, "groups");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy groups error", e);
        }
    }

    @Override
    public String getBuddySubscription(String owner, String buddy) throws RepositoryException {
        try {
            return this.repository.getData(owner, "roster/" + buddy, "subscription");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy subscription status error", e);
        }
    }

    @Override
    public Element getItem(String nodeName, String id) throws RepositoryException {
        try {
            String itemData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "data");
            char[] data = itemData.toCharArray();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
            Queue q = domHandler.getParsedElements();
            return (Element)q.element();
        }
        catch (Exception e) {
            throw new RepositoryException("Item reading error", e);
        }
    }

    @Override
    public Date getItemCreationDate(String nodeName, String id) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, CREATION_DATE_KEY);
            if (tmp == null) {
                return null;
            }
            Date d = new Date(Long.parseLong(tmp));
            return d;
        }
        catch (Exception e) {
            throw new RepositoryException("Items creation-date reading error", e);
        }
    }

    public String getItemPublisher(String nodeName, String id) throws RepositoryException {
        try {
            return this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "publisher");
        }
        catch (Exception e) {
            throw new RepositoryException("Items publisher reading error", e);
        }
    }

    @Override
    public String[] getItemsIds(String nodeName) throws RepositoryException {
        try {
            String[] ids = this.repository.getSubnodes(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY);
            return ids;
        }
        catch (Exception e) {
            throw new RepositoryException("Items list reading error", e);
        }
    }

    @Override
    public Date getItemUpdateDate(String nodeName, String id) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "update-date");
            if (tmp == null) {
                return null;
            }
            Date d = new Date(Long.parseLong(tmp));
            return d;
        }
        catch (Exception e) {
            throw new RepositoryException("Items update-date reading error", e);
        }
    }

    @Override
    public NodeAffiliations getNodeAffiliations(String nodeName) throws RepositoryException {
        try {
            String cnfData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, "affiliations");
            return NodeAffiliations.create(cnfData);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers reading error", e);
        }
    }

    public <T extends AbstractNodeConfig> T getNodeConfig(Class<T> nodeConfigClass, String nodeName, Form configForm) throws RepositoryException {
        try {
            Constructor<T> constructor = nodeConfigClass.getConstructor(String.class);
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)constructor.newInstance(nodeName);
            nodeConfig.copyFromForm(configForm);
            return (T)nodeConfig;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    @Override
    public AbstractNodeConfig getNodeConfig(String nodeName) throws RepositoryException {
        try {
            Form cnfForm = this.readNodeConfigForm(nodeName);
            if (cnfForm == null) {
                return null;
            }
            NodeType type = NodeType.valueOf(cnfForm.getAsString("pubsub#node_type"));
            Class cl = null;
            switch (type) {
                case collection: {
                    cl = CollectionNodeConfig.class;
                    break;
                }
                case leaf: {
                    cl = LeafNodeConfig.class;
                    break;
                }
                default: {
                    throw new RepositoryException("Unknown node type " + (Object)((Object)type));
                }
            }
            CollectionNodeConfig nc = this.getNodeConfig(cl, nodeName, cnfForm);
            return nc;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    public Date getNodeCreationDate(String nodeName) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, CREATION_DATE_KEY);
            long l = Long.parseLong(tmp);
            return new Date(l);
        }
        catch (Exception e) {
            throw new RepositoryException("Node creation date getting error", e);
        }
    }

    @Override
    public String[] getNodesList() throws RepositoryException {
        try {
            this.log.finer("Getting nodes list directly from DB");
            String[] nodes = this.repository.getSubnodes(this.config.getServiceName(), NODES_KEY);
            return nodes;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Nodes list getting error", e);
            throw new RepositoryException("Nodes list getting error", e);
        }
    }

    @Override
    public NodeSubscriptions getNodeSubscriptions(String nodeName) throws RepositoryException {
        try {
            NodeSubscriptions ns = NodeSubscriptions.create();
            int index = 0;
            while (true) {
                String key = "subscriptions" + (index == 0 ? "" : "." + index);
                String cnfData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, key);
                if (cnfData == null || cnfData.length() == 0) break;
                ns.parse(cnfData);
                ++index;
            }
            return ns;
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers reading error", e);
        }
    }

    @Override
    public String[] getRootNodes() throws RepositoryException {
        try {
            String[] ids = this.repository.getKeys(this.config.getServiceName(), ROOT_COLLECTION_KEY);
            return ids;
        }
        catch (Exception e) {
            throw new RepositoryException("Getting root collection error", e);
        }
    }

    @Override
    public String[] getUserRoster(String owner) throws RepositoryException {
        try {
            return this.repository.getSubnodes(owner, "roster");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting user roster error", e);
        }
    }

    @Override
    public void init() throws RepositoryException {
        try {
            this.repository.setData(this.config.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
        }
        catch (UserNotFoundException e) {
            try {
                this.repository.addUser(this.config.getServiceName());
                this.repository.setData(this.config.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
            }
            catch (Exception e1) {
                this.log.log(Level.SEVERE, "PubSub repository initialization problem", e1);
                throw new RepositoryException("Cannot initialize PubSUb repository", e);
            }
        }
        catch (TigaseDBException e) {
            this.log.log(Level.SEVERE, "PubSub repository initialization problem", e);
            throw new RepositoryException("Cannot initialize PubSUb repository", e);
        }
    }

    @Override
    public void destroy() {
    }

    private Form readNodeConfigForm(String nodeName) throws UserNotFoundException, TigaseDBException {
        String cnfData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, "configuration");
        if (cnfData == null) {
            return null;
        }
        char[] data = cnfData.toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        if (q != null && q.size() > 0) {
            Form form = new Form((Element)q.element());
            return form;
        }
        return null;
    }

    public void removeAllFromRootCollection() throws RepositoryException {
        try {
            this.repository.removeSubnode(this.config.getServiceName(), ROOT_COLLECTION_KEY);
        }
        catch (Exception e) {
            throw new RepositoryException("Removing root collection error", e);
        }
    }

    @Override
    public void removeFromRootCollection(String nodeName) throws RepositoryException {
        try {
            this.repository.removeData(this.config.getServiceName(), ROOT_COLLECTION_KEY, nodeName);
        }
        catch (Exception e) {
            throw new RepositoryException("Removing from root collection error", e);
        }
    }

    public void removeSubscriptions(String nodeName, int changedIndex) throws RepositoryException {
        try {
            String key = "subscriptions" + (changedIndex == 0 ? "" : "." + changedIndex);
            this.log.fine("Removing node '" + nodeName + "' subscriptions fragment...");
            this.repository.removeData(this.config.getServiceName(), NODES_KEY + nodeName, key);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers fragment removing error", e);
        }
    }

    @Override
    public void update(String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        String cnf = nodeConfig.getFormElement().toString();
        this.updateNodeConfig(nodeName, cnf);
    }

    @Override
    public void update(String nodeName, IAffiliations affiliations) throws RepositoryException {
        String data = affiliations.serialize();
        this.updateAffiliations(nodeName, data);
    }

    public void updateAffiliations(String nodeName, String serializedData) throws RepositoryException {
        try {
            this.log.fine("Writing node '" + nodeName + "' affiliations...");
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, "affiliations", serializedData);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
    }

    public void updateNodeConfig(String nodeName, String serializedData) throws RepositoryException {
        try {
            this.log.fine("Writing node '" + nodeName + "' configuration...");
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, "configuration", serializedData);
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration writing error", e);
        }
    }

    public void updateSubscriptions(String nodeName, int changedIndex, String serializedData) throws RepositoryException {
        try {
            String key = "subscriptions" + (changedIndex == 0 ? "" : "." + changedIndex);
            this.log.fine("Writing node '" + nodeName + "' subscriptions...");
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, key, serializedData);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
    }

    @Override
    public void writeItem(String nodeName, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        try {
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "data", item.toString());
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, CREATION_DATE_KEY, String.valueOf(timeInMilis));
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "update-date", String.valueOf(timeInMilis));
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "publisher", publisher);
        }
        catch (Exception e) {
            throw new RepositoryException("Item writing error", e);
        }
    }
}

