/*
 * Decompiled with CFR 0.152.
 */
package tigase.adhoc;

import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class AdHocCommandException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Authorization errorCondition;
    private Element item;
    private String message;
    private String xmlns = "urn:ietf:params:xml:ns:xmpp-stanzas";

    public AdHocCommandException(Authorization errorCondition) {
        this(null, errorCondition, null);
    }

    public AdHocCommandException(Authorization errorCondition, String message) {
        this(null, errorCondition, message);
    }

    public AdHocCommandException(Element item, Authorization errorCondition) {
        this(item, errorCondition, null);
    }

    public AdHocCommandException(Element item, Authorization errorCondition, String message) {
        this.item = item;
        this.errorCondition = errorCondition;
        this.message = message;
    }

    public String getCode() {
        return String.valueOf(this.errorCondition.getErrorCode());
    }

    public Authorization getErrorCondition() {
        return this.errorCondition;
    }

    public Element getItem() {
        return this.item;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.errorCondition.getCondition();
    }

    public String getType() {
        return this.errorCondition.getErrorType();
    }

    public Element makeElement() {
        return this.makeElement(true);
    }

    public Element makeElement(boolean insertOriginal) {
        Element answer = insertOriginal ? this.item.clone() : new Element(this.item.getName());
        answer.addAttribute("id", this.item.getAttribute("id"));
        answer.addAttribute("type", "error");
        answer.addAttribute("to", this.item.getAttribute("from"));
        answer.addAttribute("from", this.item.getAttribute("to"));
        if (this.message != null) {
            Element text = new Element("text", this.message, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-stanzas"});
            answer.addChild((XMLNodeIfc)text);
        }
        answer.addChild((XMLNodeIfc)this.makeErrorElement());
        return answer;
    }

    public Element makeElement(Element sourceElement) {
        this.item = sourceElement;
        return this.makeElement(true);
    }

    public Element makeErrorElement() {
        Element error = new Element("error");
        error.setAttribute("code", String.valueOf(this.errorCondition.getErrorCode()));
        error.setAttribute("type", this.errorCondition.getErrorType());
        error.addChild((XMLNodeIfc)new Element(this.errorCondition.getCondition(), new String[]{"xmlns"}, new String[]{this.xmlns}));
        return error;
    }
}

