/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.HashMap;
import java.util.Map;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.JIDUtils;

public class NodeSubscriptions
implements ISubscriptions {
    private static final String DELIMITER = ";";
    private boolean changed = false;
    private final Map<String, UsersSubscription> subs = new HashMap<String, UsersSubscription>();

    public static NodeSubscriptions create(String data) {
        NodeSubscriptions s = new NodeSubscriptions();
        try {
            String[] tokens = data.split(DELIMITER);
            int c = 0;
            String jid = null;
            String subid = null;
            String state = null;
            for (String t : tokens) {
                if (c == 2) {
                    state = t;
                    ++c;
                } else if (c == 1) {
                    subid = t;
                    ++c;
                } else if (c == 0) {
                    jid = t;
                    ++c;
                }
                if (c != 3) continue;
                UsersSubscription b = new UsersSubscription(jid, subid, Subscription.valueOf(state));
                s.subs.put(jid, b);
                jid = null;
                subid = null;
                state = null;
                c = 0;
            }
            return s;
        }
        catch (Exception e) {
            return new NodeSubscriptions();
        }
    }

    private NodeSubscriptions() {
    }

    @Override
    public String addSubscriberJid(String jid, Subscription subscription) {
        String subid = Utils.createUID();
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        this.subs.put(bareJid, s);
        this.changed = true;
        return subid;
    }

    @Override
    public void changeSubscription(String jid, Subscription subscription) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = this.subs.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
            this.changed = true;
        }
    }

    @Override
    public Subscription getSubscription(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = this.subs.get(bareJid);
        if (s != null) {
            return s.getSubscription();
        }
        return Subscription.none;
    }

    @Override
    public String getSubscriptionId(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = this.subs.get(bareJid);
        if (s != null) {
            return s.getSubid();
        }
        return null;
    }

    @Override
    public UsersSubscription[] getSubscriptions() {
        return this.subs.values().toArray(new UsersSubscription[0]);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public String serialize() {
        return this.serialize(false);
    }

    @Override
    public String serialize(boolean resetChangeFlag) {
        StringBuilder sb = new StringBuilder();
        for (UsersSubscription s : this.subs.values()) {
            if (s.getSubscription() == Subscription.none) continue;
            sb.append(s.getJid());
            sb.append(DELIMITER);
            sb.append(s.getSubid());
            sb.append(DELIMITER);
            sb.append(s.getSubscription().name());
            sb.append(DELIMITER);
        }
        if (resetChangeFlag) {
            this.changed = false;
        }
        return sb.toString();
    }
}

