/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.HashMap;
import java.util.Map;
import tigase.pubsub.Affiliation;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.util.JIDUtils;

public class NodeAffiliations
implements IAffiliations {
    private static final String DELIMITER = ";";
    private final Map<String, UsersAffiliation> affs = new HashMap<String, UsersAffiliation>();
    private boolean changed = false;

    public static NodeAffiliations create(String data) {
        NodeAffiliations a = new NodeAffiliations();
        try {
            String[] tokens = data.split(DELIMITER);
            int c = 0;
            String jid = null;
            String state = null;
            for (String t : tokens) {
                if (c == 1) {
                    state = t;
                    ++c;
                } else if (c == 0) {
                    jid = t;
                    ++c;
                }
                if (c != 2) continue;
                UsersAffiliation b = new UsersAffiliation(jid, Affiliation.valueOf(state));
                a.affs.put(jid, b);
                jid = null;
                state = null;
                c = 0;
            }
            return a;
        }
        catch (Exception e) {
            return new NodeAffiliations();
        }
    }

    @Override
    public void addAffiliation(String jid, Affiliation affiliation) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersAffiliation a = new UsersAffiliation(bareJid, affiliation);
        this.affs.put(bareJid, a);
        this.changed = true;
    }

    @Override
    public void changeAffiliation(String jid, Affiliation affiliation) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersAffiliation a = this.affs.get(bareJid);
        if (a != null) {
            a.setAffiliation(affiliation);
            this.changed = true;
        } else {
            a = new UsersAffiliation(bareJid, affiliation);
            this.affs.put(bareJid, a);
            this.changed = true;
        }
    }

    @Override
    public UsersAffiliation[] getAffiliations() {
        return this.affs.values().toArray(new UsersAffiliation[0]);
    }

    @Override
    public UsersAffiliation getSubscriberAffiliation(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersAffiliation a = this.affs.get(bareJid);
        if (a == null) {
            a = new UsersAffiliation(bareJid, Affiliation.none);
        }
        return a;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public String serialize() {
        return this.serialize(false);
    }

    @Override
    public String serialize(boolean resetChangeFlag) {
        StringBuilder sb = new StringBuilder();
        for (UsersAffiliation a : this.affs.values()) {
            if (a.getAffiliation() == Affiliation.none) continue;
            sb.append(a.getJid());
            sb.append(DELIMITER);
            sb.append(a.getAffiliation().name());
            sb.append(DELIMITER);
        }
        return sb.toString();
    }
}

