/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class UnsubscribeNodeModule
extends AbstractModule {
    private static final Criteria CRIT_UNSUBSCRIBE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"unsubscribe"));

    public UnsubscribeNodeModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_UNSUBSCRIBE;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element unsubscribe = pubSub.getChild("unsubscribe");
        String nodeName = unsubscribe.getAttribute("node");
        String jid = unsubscribe.getAttribute("jid");
        String subid = unsubscribe.getAttribute("subid");
        try {
            String s;
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            UsersAffiliation affiliation = nodeAffiliations.getSubscriberAffiliation(jid);
            if (affiliation.getAffiliation() != Affiliation.owner && !JIDUtils.getNodeID((String)jid).equals(JIDUtils.getNodeID((String)element.getAttribute("from")))) {
                throw new PubSubException(element, Authorization.BAD_REQUEST, PubSubErrorCondition.INVALID_JID);
            }
            if (affiliation != null && affiliation.getAffiliation() == Affiliation.outcast) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
            if (subid != null && !subid.equals(s = nodeSubscriptions.getSubscriptionId(jid))) {
                throw new PubSubException(element, Authorization.NOT_ACCEPTABLE, PubSubErrorCondition.INVALID_SUBID);
            }
            Subscription subscription = nodeSubscriptions.getSubscription(jid);
            if (subscription == null) {
                throw new PubSubException(Authorization.UNEXPECTED_REQUEST, PubSubErrorCondition.NOT_SUBSCRIBED);
            }
            nodeSubscriptions.changeSubscription(jid, Subscription.none);
            if (nodeSubscriptions.isChanged()) {
                this.repository.update(nodeName, nodeSubscriptions);
            }
            return UnsubscribeNodeModule.makeArray(UnsubscribeNodeModule.createResultIQ(element));
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

