/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class RetrieveSubscriptionsModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"subscriptions"));

    public RetrieveSubscriptionsModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-subscriptions"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        try {
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element subscriptions = pubsub.getChild("subscriptions");
            String nodeName = subscriptions.getAttribute("node");
            String senderJid = element.getAttribute("from");
            String senderBareJid = JIDUtils.getNodeID((String)senderJid);
            Element result = RetrieveSubscriptionsModule.createResultIQ(element);
            Element pubsubResult = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            result.addChild(pubsubResult);
            Element subscriptionsResult = new Element("subscriptions");
            pubsubResult.addChild(subscriptionsResult);
            if (nodeName == null) {
                IPubSubDAO directRepo = this.repository.getPubSubDAO();
                String[] nodes = directRepo.getNodesList();
                if (nodes != null) {
                    for (String node : nodes) {
                        NodeSubscriptions subscribers = directRepo.getNodeSubscriptions(node);
                        if (subscribers == null) continue;
                        for (UsersSubscription usersSubscription : subscribers.getSubscriptions()) {
                            if (!senderBareJid.equals(JIDUtils.getNodeID((String)usersSubscription.getJid()))) continue;
                            NodeSubscriptions ns = directRepo.getNodeSubscriptions(nodeName);
                            Subscription subscription = ns.getSubscription(usersSubscription.getJid());
                            Element a = new Element("subscription", new String[]{"node", "jid", "subscription"}, new String[]{node, usersSubscription.getJid(), subscription.name()});
                            subscriptionsResult.addChild(a);
                        }
                    }
                }
            } else {
                UsersSubscription[] subscribers;
                ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
                subscriptionsResult.addAttribute("node", nodeName);
                for (UsersSubscription usersSubscription : subscribers = nodeSubscriptions.getSubscriptions()) {
                    Element s = new Element("subscription", new String[]{"jid", "subscription", "subid"}, new String[]{usersSubscription.getJid(), usersSubscription.getSubscription().name(), usersSubscription.getSubid()});
                    subscriptionsResult.addChild(s);
                }
            }
            return RetrieveSubscriptionsModule.makeArray(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

