/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class RetrieveItemsModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"items"));

    public RetrieveItemsModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    private Integer asInteger(String attribute) {
        if (attribute == null) {
            return null;
        }
        return Integer.parseInt(attribute);
    }

    private List<String> extractItemsIds(Element items) throws PubSubException {
        List il = items.getChildren();
        if (il == null || il.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element i : il) {
            String id = i.getAttribute("id");
            if (!"item".equals(i.getName()) || id == null) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            result.add(id);
        }
        return result;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-items"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        try {
            String[] ids;
            boolean allowed;
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element items = pubsub.getChild("items");
            String nodeName = items.getAttribute("node");
            Integer maxItems = this.asInteger(items.getAttribute("max_items"));
            String senderJid = element.getAttribute("from");
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeAccessModel() == AccessModel.open && !Utils.isAllowedDomain(senderJid, nodeConfig.getDomains())) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid);
            if (senderAffiliation.getAffiliation() == Affiliation.outcast) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
            Subscription senderSubscription = nodeSubscriptions.getSubscription(senderJid);
            if (nodeConfig.getNodeAccessModel() == AccessModel.whitelist && !senderAffiliation.getAffiliation().isRetrieveItem()) {
                throw new PubSubException(Authorization.NOT_ALLOWED, PubSubErrorCondition.CLOSED_NODE);
            }
            if (!(nodeConfig.getNodeAccessModel() != AccessModel.authorize || senderSubscription == Subscription.subscribed && senderAffiliation.getAffiliation().isRetrieveItem())) {
                throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_SUBSCRIBED);
            }
            if (nodeConfig.getNodeAccessModel() == AccessModel.presence) {
                allowed = this.hasSenderSubscription(senderJid, nodeAffiliations, nodeSubscriptions);
                if (!allowed) {
                    throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.PRESENCE_SUBSCRIPTION_REQUIRED);
                }
            } else if (nodeConfig.getNodeAccessModel() == AccessModel.roster && !(allowed = this.isSenderInRosterGroup(senderJid, nodeConfig, nodeAffiliations, nodeSubscriptions))) {
                throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_IN_ROSTER_GROUP);
            }
            if (nodeConfig instanceof CollectionNodeConfig) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "retrieve-items"));
            }
            if (nodeConfig instanceof LeafNodeConfig && !((LeafNodeConfig)nodeConfig).isPersistItem()) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "persistent-items"));
            }
            List<String> requestedId = this.extractItemsIds(items);
            Element iq = RetrieveItemsModule.createResultIQ(element);
            Element rpubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Element ritems = new Element("items", new String[]{"node"}, new String[]{nodeName});
            rpubsub.addChild(ritems);
            iq.addChild(rpubsub);
            if (requestedId == null && (ids = this.repository.getItemsIds(nodeName)) != null) {
                requestedId = Arrays.asList(ids);
            }
            if (requestedId != null) {
                int c = 0;
                for (String id : requestedId) {
                    Element item = this.repository.getItem(nodeName, id);
                    if (item == null) continue;
                    if (maxItems != null && ++c > maxItems) break;
                    ritems.addChild(item);
                }
            }
            return RetrieveItemsModule.makeArray(iq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

