/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class RetractItemModule
extends AbstractModule {
    private static final Criteria CRIT_RETRACT = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"retract"));
    private final PublishItemModule publishModule;

    public RetractItemModule(PubSubConfig config, IPubSubRepository pubsubRepository, PublishItemModule publishItemModule) {
        super(config, pubsubRepository);
        this.publishModule = publishItemModule;
    }

    private Element createNotification(LeafNodeConfig config, List<String> itemsToSend, String nodeName) {
        Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
        for (String id : itemsToSend) {
            items.addChild(new Element("retract", new String[]{"id"}, new String[]{id}));
        }
        return items;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retract-items"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_RETRACT;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element retract = pubSub.getChild("retract");
        String nodeName = retract.getAttribute("node");
        try {
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeType() == NodeType.collection) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "retract-items"));
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            UsersAffiliation affiliation = nodeAffiliations.getSubscriberAffiliation(element.getAttribute("from"));
            if (!affiliation.getAffiliation().isDeleteItem()) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
            if (!leafNodeConfig.isPersistItem()) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "persistent-items"));
            }
            ArrayList<String> itemsToDelete = new ArrayList<String>();
            if (retract.getChildren() != null) {
                for (Element item : retract.getChildren()) {
                    String n = item.getAttribute("id");
                    if (n != null) {
                        itemsToDelete.add(n);
                        continue;
                    }
                    throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.ITEM_REQUIRED);
                }
            } else {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.ITEM_REQUIRED);
            }
            ArrayList<Element> result = new ArrayList<Element>();
            result.add(RetractItemModule.createResultIQ(element));
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
            for (String id : itemsToDelete) {
                Date date = this.repository.getItemCreationDate(nodeName, id);
                if (date == null) continue;
                Element notification = this.createNotification(leafNodeConfig, itemsToDelete, nodeName);
                result.addAll(this.publishModule.prepareNotification(notification, element.getAttribute("to"), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
                this.repository.deleteItem(nodeName, id);
            }
            return result;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

