/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class ManageAffiliationsModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"affiliations"));

    private static Element createAffiliationNotification(String fromJid, String toJid, String nodeName, Affiliation affilation) {
        Element message = new Element("message", new String[]{"from", "to"}, new String[]{fromJid, toJid});
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        message.addChild(pubsub);
        Element affilations = new Element("affiliations", new String[]{"node"}, new String[]{nodeName});
        pubsub.addChild(affilations);
        affilations.addChild(new Element("affilation", new String[]{"jid", "affiliation"}, new String[]{toJid, affilation.name()}));
        return message;
    }

    public ManageAffiliationsModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#modify-affiliations"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        try {
            UsersAffiliation senderAffiliation;
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element affiliations = pubsub.getChild("affiliations");
            String nodeName = affiliations.getAttribute("node");
            String type = element.getAttribute("type");
            if (type == null || !type.equals("get") && !type.equals("set")) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            String senderJid = element.getAttribute("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            List<Object> result = new ArrayList();
            if (type.equals("get")) {
                result = this.processGet(element, affiliations, nodeName, nodeAffiliations);
            } else if (type.equals("set")) {
                result = this.processSet(element, affiliations, nodeName, nodeAffiliations);
            }
            if (nodeAffiliations.isChanged()) {
                this.repository.update(nodeName, nodeAffiliations);
            }
            return result;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<Element> processGet(Element element, Element affiliations, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        ArrayList<Element> result = new ArrayList<Element>();
        Element iq = ManageAffiliationsModule.createResultIQ(element);
        Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
        iq.addChild(ps);
        Element afr = new Element("affiliations", new String[]{"node"}, new String[]{nodeName});
        ps.addChild(afr);
        UsersAffiliation[] affiliationsList = nodeAffiliations.getAffiliations();
        if (affiliationsList != null) {
            for (UsersAffiliation affi : affiliationsList) {
                if (affi.getAffiliation() == Affiliation.none) continue;
                Element affiliation = new Element("affiliation", new String[]{"jid", "affiliation"}, new String[]{affi.getJid(), affi.getAffiliation().name()});
                afr.addChild(affiliation);
            }
        }
        result.add(iq);
        return result;
    }

    private List<Element> processSet(Element element, Element affiliations, String nodeName, IAffiliations nodeAffiliations) throws PubSubException, RepositoryException {
        ArrayList<Element> result = new ArrayList<Element>();
        Element iq = ManageAffiliationsModule.createResultIQ(element);
        result.add(iq);
        List affs = affiliations.getChildren();
        for (Element a : affs) {
            if ("affiliation".equals(a.getName())) continue;
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        for (Element af : affs) {
            String strAfiliation = af.getAttribute("affiliation");
            String jid = af.getAttribute("jid");
            if (strAfiliation == null) continue;
            Affiliation newAffiliation = Affiliation.valueOf(strAfiliation);
            Affiliation oldAffiliation = nodeAffiliations.getSubscriberAffiliation(jid).getAffiliation();
            Affiliation affiliation = oldAffiliation = oldAffiliation == null ? Affiliation.none : oldAffiliation;
            if (oldAffiliation == Affiliation.none && newAffiliation != Affiliation.none) {
                nodeAffiliations.addAffiliation(jid, newAffiliation);
                result.add(ManageAffiliationsModule.createAffiliationNotification(element.getAttribute("to"), jid, nodeName, newAffiliation));
                continue;
            }
            nodeAffiliations.changeAffiliation(jid, newAffiliation);
            result.add(ManageAffiliationsModule.createAffiliationNotification(element.getAttribute("to"), jid, nodeName, newAffiliation));
        }
        return result;
    }
}

