/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.Module;
import tigase.pubsub.PubSubVersion;
import tigase.pubsub.exceptions.PubSubException;
import tigase.xml.Element;

public class JabberVersionModule
implements Module {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"jabber:iq:version"));

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        ArrayList<Element> result = new ArrayList<Element>();
        Element iq = new Element("iq", new String[]{"to", "from", "id", "type"}, new String[]{element.getAttribute("from"), element.getAttribute("to"), element.getAttribute("id"), "result"});
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:version"});
        query.addChild(new Element("name", "Tigase PubSub"));
        query.addChild(new Element("version", PubSubVersion.getVersion()));
        query.addChild(new Element("os", System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "-" + System.getProperty("os.version") + ", " + System.getProperty("java.vm.name") + "-" + System.getProperty("java.version") + " " + System.getProperty("java.vm.vendor")));
        iq.addChild(query);
        result.add(iq);
        return result;
    }
}

