/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.SimpleForwarder;

public class PubSubPlugin
extends SimpleForwarder {
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", "pep"})};
    private static final String[] ELEMENTS = new String[]{"pubsub"};
    private static final Object PUBSUB_COMPONENT_URL = "pubsub-component";
    private static final String XMLNS = "http://jabber.org/protocol/pubsub";
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/pubsub"};
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public String id() {
        return "pubsub";
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        String pubSubComponentUrl = (String)settings.get(PUBSUB_COMPONENT_URL);
        if (packet.getElemTo() == null || packet.getElemTo().equals("sphere")) {
            this.log.finest("Forwarding packet to: " + pubSubComponentUrl);
            packet.getElement().setAttribute("to", pubSubComponentUrl);
        } else {
            this.log.finest("Leaving packet As Is");
        }
        super.process(packet, session, repo, results, settings);
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    public String[] supElements() {
        return ELEMENTS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }
}

