/*
 * Decompiled with CFR 0.152.
 */
package tigase.adhoc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdHocSession;
import tigase.adhoc.AdhHocRequest;
import tigase.util.SimpleCache;
import tigase.xml.Element;

public class AdHocCommandManager {
    private final Map<String, AdHocCommand> commands = new HashMap<String, AdHocCommand>();
    private final SimpleCache<String, AdHocSession> sessions = new SimpleCache(100, 10000L);

    public Collection<AdHocCommand> getAllCommands() {
        return this.commands.values();
    }

    public Element process(Element element) throws AdHocCommandException {
        String senderJid = element.getAttribute("from");
        Element command = element.getChild("command", "http://jabber.org/protocol/commands");
        String node = command.getAttribute("node");
        String action = command.getAttribute("action");
        String sessionId = command.getAttribute("sessionid");
        AdHocCommand adHocCommand = this.commands.get(node);
        if (adHocCommand != null) {
            Element iqResult = new Element("iq", new String[]{"from", "to", "id", "type"}, new String[]{element.getAttribute("to"), senderJid, element.getAttribute("id"), "result"});
            AdHocResponse.State currentState = null;
            AdhHocRequest request = new AdhHocRequest(element, command, node, senderJid, action, sessionId);
            AdHocResponse response = new AdHocResponse(sessionId, currentState);
            AdHocSession session = sessionId == null ? new AdHocSession() : (AdHocSession)this.sessions.get((Object)sessionId);
            adHocCommand.execute(request, response);
            Element commandResult = new Element("command", new String[]{"xmlns", "node"}, new String[]{"http://jabber.org/protocol/commands", node});
            commandResult.addAttribute("status", response.getNewState().name());
            if (response.getCurrentState() == null && response.getNewState() == AdHocResponse.State.executing) {
                this.sessions.put((Object)response.getSessionid(), (Object)session);
            } else if (response.getSessionid() != null && (response.getNewState() == AdHocResponse.State.canceled || response.getNewState() == AdHocResponse.State.completed)) {
                this.sessions.remove((Object)response.getSessionid());
            }
            if (response.getSessionid() != null) {
                commandResult.addAttribute("sessionid", response.getSessionid());
            }
            for (Element r : response.getElements()) {
                commandResult.addChild(r);
            }
            iqResult.addChild(commandResult);
            return iqResult;
        }
        return null;
    }

    public void registerCommand(AdHocCommand command) {
        this.commands.put(command.getNode(), command);
    }
}

