/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.inmemory.Item;
import tigase.pubsub.repository.inmemory.NodeAffiliation;
import tigase.pubsub.repository.inmemory.Subscriber;
import tigase.util.JIDUtils;

class Entry {
    private static final Comparator<Item> comparator = new Comparator<Item>(){

        @Override
        public int compare(Item o1, Item o2) {
            return -o1.getCreationDate().compareTo(o2.getCreationDate());
        }
    };
    public static final NodeAffiliation NONE_AFFILIATION = new NodeAffiliation(null, Affiliation.none);
    private final HashMap<String, NodeAffiliation> affiliations = new HashMap();
    private final AbstractNodeConfig config;
    private final Date creationDate;
    private final HashMap<String, Item> items = new HashMap();
    private final String name;
    private final ArrayList<Item> sortedItems = new ArrayList();
    private final HashMap<String, Subscriber> subscriptions = new HashMap();

    Entry(String name, Date creationDate, AbstractNodeConfig config, List<Subscriber> subscribers, List<NodeAffiliation> affiliations, List<Item> items) {
        this.name = name;
        this.creationDate = creationDate;
        this.config = config;
        if (affiliations != null) {
            for (NodeAffiliation affiliation : affiliations) {
                this.add(affiliation);
            }
        }
        if (items != null) {
            for (Item item : items) {
                this.add(item);
            }
        }
        if (subscribers != null) {
            for (Subscriber subscriber : subscribers) {
                this.add(subscriber);
            }
        }
    }

    public void add(Item it) {
        this.items.put(it.getId(), it);
        this.sortedItems.add(it);
        this.sortItems();
    }

    public void add(NodeAffiliation nodeAffiliation) {
        this.affiliations.put(nodeAffiliation.getJid(), nodeAffiliation);
    }

    public void add(Subscriber subscriber) {
        this.subscriptions.put(subscriber.getJid(), subscriber);
    }

    public void changeAffiliation(String jid, Affiliation affiliation) {
        NodeAffiliation na = this.affiliations.get(JIDUtils.getNodeID((String)jid));
        na.setAffiliation(affiliation);
    }

    public void changeSubscription(String jid, Subscription subscription) {
        Subscriber subscriber = this.subscriptions.get(jid);
        subscriber.setSubscription(subscription);
    }

    public void deleteItem(String id) {
        Item x = this.items.remove(id);
        if (x != null) {
            this.sortedItems.remove(x);
        }
    }

    public NodeAffiliation[] getAffiliations() {
        return this.affiliations.values().toArray(new NodeAffiliation[0]);
    }

    public AbstractNodeConfig getConfig() {
        return this.config;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getItemCreationDate(String id) {
        Item item = this.items.get(id);
        if (item != null) {
            return item.getCreationDate();
        }
        return null;
    }

    public Item getItemData(String id) {
        return this.items.get(id);
    }

    public String getName() {
        return this.name;
    }

    public String[] getSortedItemsId() {
        String[] result = new String[this.sortedItems.size()];
        for (int i = 0; i < this.sortedItems.size(); ++i) {
            result[i] = this.sortedItems.get(i).getId();
        }
        return result;
    }

    public NodeAffiliation getSubscriberAffiliation(String jid) {
        NodeAffiliation na = this.affiliations.get(JIDUtils.getNodeID((String)jid));
        return na == null ? NONE_AFFILIATION : na;
    }

    public Subscriber[] getSubscribersJid() {
        return this.subscriptions.values().toArray(new Subscriber[0]);
    }

    public Subscription getSubscriberSubscription(String jid) {
        Subscriber subscriber = this.subscriptions.get(jid);
        if (subscriber == null) {
            subscriber = this.subscriptions.get(JIDUtils.getNodeID((String)jid));
        }
        if (subscriber == null) {
            return Subscription.none;
        }
        return subscriber.getSubscription();
    }

    public String getSubscriptionId(String jid) {
        Subscriber subscriber = this.subscriptions.get(jid);
        return subscriber == null ? null : subscriber.getSubid();
    }

    public void removeSubscriber(String jid) {
        this.subscriptions.remove(jid);
    }

    private void sortItems() {
        Collections.sort(this.sortedItems, comparator);
    }
}

