/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.ElementCache;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.ListCache;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.Affiliations;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.PubSubRepositoryListener;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.Subscriptions;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class PubSubDAO
implements IPubSubDAO {
    private static final String ACCESS_MODEL_KEY = "pubsub#access_model";
    private static final String ASSOCIATE_COLLECTION_KEY = "pubsub#collection";
    public static final String CREATION_DATE_KEY = "creation-date";
    private static final String ITEMS_KEY = "items";
    private static final long MAX_CACHE_TIME = 2000L;
    private static final String NODE_TYPE_KEY = "pubsub#node_type";
    public static final String NODES_KEY = "nodes/";
    private static final String ROOT_COLLECTION_KEY = "root-collection";
    private static final String SUBSCRIPTIONS_KEY = "subscriptions";
    private final ListCache<String, String> collectionCache = new ListCache(1000, 2000L);
    final PubSubConfig config;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private final ListCache<String, AbstractNodeConfig> nodesConfigCache = new ListCache(1000, 2000L);
    private final ElementCache<String[]> nodesListCache = new ElementCache(2000L);
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    final UserRepository repository;

    public PubSubDAO(UserRepository repository, PubSubConfig pubSubConfig) throws RepositoryException {
        this.repository = repository;
        this.config = pubSubConfig;
        try {
            this.repository.setData(this.config.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
        }
        catch (UserNotFoundException e) {
            try {
                this.repository.addUser(this.config.getServiceName());
                this.repository.setData(this.config.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
            }
            catch (Exception e1) {
                this.log.log(Level.SEVERE, "PubSub repository initialization problem", e1);
                throw new RepositoryException("Cannot initialize PubSUb repository", e);
            }
        }
        catch (TigaseDBException e) {
            this.log.log(Level.SEVERE, "PubSub repository initialization problem", e);
            throw new RepositoryException("Cannot initialize PubSUb repository", e);
        }
    }

    @Override
    public void addListener(PubSubRepositoryListener listener) {
        throw new RuntimeException("Listeners are unsupported");
    }

    @Override
    public void addToRootCollection(String nodeName) throws RepositoryException {
        try {
            this.repository.setData(this.config.getServiceName(), ROOT_COLLECTION_KEY, nodeName, "root");
        }
        catch (Exception e) {
            throw new RepositoryException("Adding to root collection error", e);
        }
    }

    @Override
    public void changeSubscription(String nodeName, String jid, Subscription subscription) throws RepositoryException {
        try {
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + SUBSCRIPTIONS_KEY + "/" + jid, "subscription", subscription.name());
        }
        catch (Exception e) {
            throw new RepositoryException("Subscription writing error", e);
        }
    }

    @Override
    public void createNode(String nodeName, String ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        try {
            nodeConfig.setNodeType(nodeType);
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, CREATION_DATE_KEY, String.valueOf(System.currentTimeMillis()));
            if (nodeConfig != null) {
                this.update(nodeName, nodeConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Node creation error", e);
        }
    }

    @Override
    public void deleteItem(String nodeName, String id) throws RepositoryException {
        try {
            this.repository.removeSubnode(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id);
        }
        catch (Exception e) {
            throw new RepositoryException("Item removing error", e);
        }
    }

    @Override
    public void deleteNode(String nodeName) throws RepositoryException {
        try {
            this.repository.removeSubnode(this.config.getServiceName(), NODES_KEY + nodeName);
        }
        catch (Exception e) {
            throw new RepositoryException("Node deleting error", e);
        }
    }

    @Override
    public void forgetConfiguration(String nodeName) {
    }

    @Override
    public String[] getBuddyGroups(String owner, String buddy) throws RepositoryException {
        try {
            return this.repository.getDataList(owner, "roster/" + buddy, "groups");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy groups error", e);
        }
    }

    @Override
    public String getBuddySubscription(String owner, String buddy) throws RepositoryException {
        try {
            return this.repository.getData(owner, "roster/" + buddy, "subscription");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy subscription status error", e);
        }
    }

    @Override
    public IPubSubDAO getDirectRepository() {
        return this;
    }

    @Override
    public Element getItem(String nodeName, String id) throws RepositoryException {
        try {
            String itemData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "data");
            char[] data = itemData.toCharArray();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
            Queue q = domHandler.getParsedElements();
            return (Element)q.element();
        }
        catch (Exception e) {
            throw new RepositoryException("Item reading error", e);
        }
    }

    @Override
    public Date getItemCreationDate(String nodeName, String id) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, CREATION_DATE_KEY);
            if (tmp == null) {
                return null;
            }
            Date d = new Date(Long.parseLong(tmp));
            return d;
        }
        catch (Exception e) {
            throw new RepositoryException("Items creation-date reading error", e);
        }
    }

    public String getItemPublisher(String nodeName, String id) throws RepositoryException {
        try {
            return this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "publisher");
        }
        catch (Exception e) {
            throw new RepositoryException("Items publisher reading error", e);
        }
    }

    @Override
    public String[] getItemsIds(String nodeName) throws RepositoryException {
        try {
            String[] ids = this.repository.getSubnodes(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY);
            return ids;
        }
        catch (Exception e) {
            throw new RepositoryException("Items list reading error", e);
        }
    }

    @Override
    public Date getItemUpdateDate(String nodeName, String id) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "update-date");
            if (tmp == null) {
                return null;
            }
            Date d = new Date(Long.parseLong(tmp));
            return d;
        }
        catch (Exception e) {
            throw new RepositoryException("Items update-date reading error", e);
        }
    }

    @Override
    public IAffiliations getNodeAffiliations(String nodeName) throws RepositoryException {
        try {
            String cnfData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, "affiliations");
            return Affiliations.create(cnfData);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers reading error", e);
        }
    }

    public <T extends AbstractNodeConfig> T getNodeConfig(Class<T> nodeConfigClass, String nodeName, Form configForm) throws RepositoryException {
        try {
            Constructor<T> constructor = nodeConfigClass.getConstructor(String.class);
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)constructor.newInstance(nodeName);
            nodeConfig.copyFromForm(configForm);
            return (T)nodeConfig;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    @Override
    public AbstractNodeConfig getNodeConfig(String nodeName) throws RepositoryException {
        AbstractNodeConfig nc = (AbstractNodeConfig)this.nodesConfigCache.get(nodeName);
        if (nc != null) {
            return nc;
        }
        try {
            Form cnfForm = this.readNodeConfigForm(nodeName);
            if (cnfForm == null) {
                return null;
            }
            NodeType type = NodeType.valueOf(cnfForm.getAsString(NODE_TYPE_KEY));
            Class cl = null;
            switch (type) {
                case collection: {
                    cl = CollectionNodeConfig.class;
                    break;
                }
                case leaf: {
                    cl = LeafNodeConfig.class;
                    break;
                }
                default: {
                    throw new RepositoryException("Unknown node type " + (Object)((Object)type));
                }
            }
            nc = this.getNodeConfig(cl, nodeName, cnfForm);
            if (nc != null) {
                this.nodesConfigCache.put(nodeName, nc);
            }
            return nc;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    public Date getNodeCreationDate(String nodeName) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, CREATION_DATE_KEY);
            long l = Long.parseLong(tmp);
            return new Date(l);
        }
        catch (Exception e) {
            throw new RepositoryException("Node creation date getting error", e);
        }
    }

    @Override
    public String[] getNodesList() throws RepositoryException {
        try {
            String[] nodes = this.nodesListCache.getData();
            if (nodes == null) {
                this.log.finer("Getting nodes list directly from DB");
                nodes = this.repository.getSubnodes(this.config.getServiceName(), NODES_KEY);
                this.nodesListCache.setData(nodes);
            } else {
                this.log.finer("Getting nodes list from Cache");
            }
            return nodes;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Nodes list getting error", e);
            throw new RepositoryException("Nodes list getting error", e);
        }
    }

    @Override
    public ISubscriptions getNodeSubscriptions(String nodeName) throws RepositoryException {
        try {
            String cnfData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, SUBSCRIPTIONS_KEY);
            return Subscriptions.create(cnfData);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers reading error", e);
        }
    }

    @Override
    public String[] getRootNodes() throws RepositoryException {
        try {
            String[] ids = this.repository.getKeys(this.config.getServiceName(), ROOT_COLLECTION_KEY);
            return ids;
        }
        catch (Exception e) {
            throw new RepositoryException("Getting root collection error", e);
        }
    }

    @Override
    public Subscription getSubscription(String nodeName, String jid) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + SUBSCRIPTIONS_KEY + "/" + jid, "subscription");
            if (tmp != null) {
                return Subscription.valueOf(tmp);
            }
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException("Subscription getting error", e);
        }
    }

    @Override
    public String getSubscriptionId(String nodeName, String jid) throws RepositoryException {
        try {
            return this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + SUBSCRIPTIONS_KEY + "/" + jid, "subid");
        }
        catch (Exception e) {
            throw new RepositoryException("SubID reading error", e);
        }
    }

    @Override
    public String[] getSubscriptions(String nodeName) throws RepositoryException {
        try {
            return this.repository.getSubnodes(this.config.getServiceName(), NODES_KEY + nodeName + "/" + SUBSCRIPTIONS_KEY);
        }
        catch (Exception e) {
            throw new RepositoryException("Subscribers getting  error", e);
        }
    }

    @Override
    public String[] getUserRoster(String owner) throws RepositoryException {
        try {
            return this.repository.getSubnodes(owner, "roster");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting user roster error", e);
        }
    }

    @Override
    public void init() {
    }

    private Form readNodeConfigForm(String nodeName) throws UserNotFoundException, TigaseDBException {
        String cnfData = this.repository.getData(this.config.getServiceName(), NODES_KEY + nodeName, "configuration");
        if (cnfData == null) {
            return null;
        }
        char[] data = cnfData.toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        if (q != null && q.size() > 0) {
            Form form = new Form((Element)q.element());
            return form;
        }
        return null;
    }

    public void removeAllFromRootCollection() throws RepositoryException {
        try {
            this.repository.removeSubnode(this.config.getServiceName(), ROOT_COLLECTION_KEY);
        }
        catch (Exception e) {
            throw new RepositoryException("Removing root collection error", e);
        }
    }

    @Override
    public void removeFromRootCollection(String nodeName) throws RepositoryException {
        try {
            this.repository.removeData(this.config.getServiceName(), ROOT_COLLECTION_KEY, nodeName);
        }
        catch (Exception e) {
            throw new RepositoryException("Removing from root collection error", e);
        }
    }

    @Override
    public void removeListener(PubSubRepositoryListener listener) {
        throw new RuntimeException("Listeners are unsupported");
    }

    @Override
    public void update(String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        try {
            String cnf = nodeConfig.getFormElement().toString();
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, "configuration", cnf);
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration writing error", e);
        }
    }

    @Override
    public void update(String nodeName, IAffiliations affiliations) throws RepositoryException {
        try {
            String data = affiliations.serialize(true);
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, "affiliations", data);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
    }

    @Override
    public void update(String nodeName, ISubscriptions subscriptions) throws RepositoryException {
        try {
            String data = subscriptions.serialize(true);
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName, SUBSCRIPTIONS_KEY, data);
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
    }

    @Override
    public void writeItem(String nodeName, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        try {
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "data", item.toString());
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, CREATION_DATE_KEY, String.valueOf(timeInMilis));
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "update-date", String.valueOf(timeInMilis));
            this.repository.setData(this.config.getServiceName(), NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "publisher", publisher);
        }
        catch (Exception e) {
            throw new RepositoryException("Item writing error", e);
        }
    }
}

