/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.inmemory.NodeAffiliation;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class RetrieveAffiliationsModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"affiliations"));

    public RetrieveAffiliationsModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-affiliations", "http://jabber.org/protocol/pubsub#publisher-affiliation", "http://jabber.org/protocol/pubsub#outcast-affiliation", "http://jabber.org/protocol/pubsub#member-affiliation"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        try {
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element affiliations = pubsub.getChild("affiliations");
            String senderJid = element.getAttribute("from");
            String senderBareJid = JIDUtils.getNodeID((String)senderJid);
            Element result = RetrieveAffiliationsModule.createResultIQ(element);
            Element pubsubResult = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            result.addChild(pubsubResult);
            Element affiliationsResult = new Element("affiliations");
            pubsubResult.addChild(affiliationsResult);
            IPubSubDAO directRepo = this.repository.getPubSubDAO();
            String[] nodes = directRepo.getNodesList();
            if (nodes != null) {
                for (String node : nodes) {
                    NodeAffiliation[] affilitaions = directRepo.getNodeAffiliations(node).getAffiliations();
                    if (affiliations == null) continue;
                    for (NodeAffiliation nodeAffiliation : affilitaions) {
                        if (!senderBareJid.equals(nodeAffiliation.getJid())) continue;
                        Affiliation affiliation = nodeAffiliation.getAffiliation();
                        Element a = new Element("affiliation", new String[]{"node", "affiliation"}, new String[]{node, affiliation.name()});
                        affiliationsResult.addChild(a);
                    }
                }
            }
            return RetrieveAffiliationsModule.makeArray(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

