/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.inmemory.NodeAffiliation;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class PublishItemModule
extends AbstractModule {
    private static final Criteria CRIT_PUBLISH = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"publish"));
    public static final String[] SUPPORTED_PEP_XMLNS = new String[]{"http://jabber.org/protocol/mood", "http://jabber.org/protocol/geoloc", "http://jabber.org/protocol/activity", "http://jabber.org/protocol/tune"};
    private long idCounter = 0L;
    private final Set<String> pepNodes = new HashSet<String>();
    private final PresenceCollectorModule presenceCollector;
    private final XsltTool xslTransformer;

    public PublishItemModule(PubSubConfig config, IPubSubRepository pubsubRepository, XsltTool xsltTool, PresenceCollectorModule presenceCollector) {
        super(config, pubsubRepository);
        this.xslTransformer = xsltTool;
        this.presenceCollector = presenceCollector;
        for (String xmlns : SUPPORTED_PEP_XMLNS) {
            this.pepNodes.add(xmlns);
        }
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#publish"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_PUBLISH;
    }

    protected List<String> getParents(String nodeName) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
        String cn = nodeConfig.getCollection();
        while (cn != null && !"".equals(cn)) {
            result.add(cn);
            AbstractNodeConfig nc = this.repository.getNodeConfig(cn);
            cn = nc.getCollection();
        }
        return result;
    }

    protected String[] getValidBuddies(String jid) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        String[] rosterJids = this.repository.getUserRoster(jid);
        if (rosterJids != null) {
            for (String j : rosterJids) {
                String sub = this.repository.getBuddySubscription(jid, j);
                if (sub == null || !sub.equals("both") && !sub.equals("from")) continue;
                result.add(j);
            }
        }
        return result.toArray(new String[0]);
    }

    public boolean isPEPNodeName(String nodeName) {
        return this.pepNodes.contains(nodeName);
    }

    private List<Element> makeItemsToSend(Element publish) {
        ArrayList<Element> items = new ArrayList<Element>();
        for (Element si : publish.getChildren()) {
            if (!"item".equals(si.getName())) continue;
            items.add(si);
        }
        return items;
    }

    private List<Element> pepProcess(Element element, Element pubSub, Element publish) throws RepositoryException {
        String senderJid = element.getAttribute("from");
        Element item = publish.getChild("item");
        Element items = new Element("items", new String[]{"node"}, new String[]{publish.getAttribute("node")});
        items.addChild(item);
        String[] subscribers = this.getValidBuddies(JIDUtils.getNodeID((String)senderJid));
        List<Element> result = this.prepareNotification(subscribers, items, senderJid, null, publish.getAttribute("node"), null);
        result.add(PublishItemModule.createResultIQ(element));
        result.addAll(this.prepareNotification(new String[]{senderJid}, items, senderJid, null, publish.getAttribute("node"), null));
        return result;
    }

    public List<Element> prepareNotification(Element itemToSend, String jidFrom, String publisherNodeName, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodesSubscriptions) throws RepositoryException {
        return this.prepareNotification(itemToSend, jidFrom, publisherNodeName, null, nodeConfig, nodeAffiliations, nodesSubscriptions);
    }

    public List<Element> prepareNotification(Element itemToSend, String jidFrom, String publisherNodeName, Map<String, String> headers, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodesSubscriptions) throws RepositoryException {
        String[] subscribers = this.getActiveSubscribers(nodeAffiliations, nodesSubscriptions);
        if (nodeConfig.isDeliverPresenceBased()) {
            ArrayList<String> s = new ArrayList<String>();
            for (String jid : subscribers) {
                for (String subjid : this.presenceCollector.getAllAvailableResources(jid)) {
                    s.add(subjid);
                }
            }
            subscribers = s.toArray(new String[0]);
        }
        return this.prepareNotification(subscribers, itemToSend, jidFrom, nodeConfig, publisherNodeName, headers);
    }

    public List<Element> prepareNotification(String[] subscribers, Element itemToSend, String jidFrom, AbstractNodeConfig nodeConfig, String publisherNodeName, Map<String, String> headers) {
        ArrayList<Element> result = new ArrayList<Element>();
        List<Element> body = null;
        if (this.xslTransformer != null && nodeConfig != null) {
            try {
                body = this.xslTransformer.transform(itemToSend, nodeConfig);
            }
            catch (Exception e) {
                body = null;
                this.log.log(Level.WARNING, "Problem with generating BODY", e);
            }
        }
        for (String jid : subscribers) {
            Element message = new Element("message", new String[]{"from", "to", "id"}, new String[]{jidFrom, jid, String.valueOf(++this.idCounter)});
            if (body != null) {
                message.addChildren(body);
            }
            Element event = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
            event.addChild(itemToSend);
            message.addChild(event);
            if (headers != null && headers.size() > 0) {
                Element headElem = new Element("headers", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/shim"});
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    Element h = new Element("header", entry.getValue(), new String[]{"name"}, new String[]{entry.getKey()});
                    headElem.addChild(h);
                }
                message.addChild(headElem);
            }
            result.add(message);
        }
        return result;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element publish = pubSub.getChild("publish");
        String nodeName = publish.getAttribute("node");
        try {
            if (this.isPEPNodeName(nodeName)) {
                return this.pepProcess(element, pubSub, publish);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeType() == NodeType.collection) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "publish"));
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            NodeAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(element.getAttribute("from"));
            if (!senderAffiliation.getAffiliation().isPublishItem()) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
            List<Element> itemsToSend = this.makeItemsToSend(publish);
            if (leafNodeConfig.isPersistItem()) {
                for (Element item : itemsToSend) {
                    String id = item.getAttribute("id");
                    if (id != null) continue;
                    throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.ITEM_REQUIRED);
                }
            }
            ArrayList<Element> result = new ArrayList<Element>();
            result.add(PublishItemModule.createResultIQ(element));
            Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
            items.addChildren(itemsToSend);
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
            result.addAll(this.prepareNotification(items, element.getAttribute("to"), nodeName, this.repository.getNodeConfig(nodeName), nodeAffiliations, nodeSubscriptions));
            List<String> parents = this.getParents(nodeName);
            if (parents != null && parents.size() > 0) {
                for (String collection : parents) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("Collection", collection);
                    AbstractNodeConfig colNodeConfig = this.repository.getNodeConfig(collection);
                    ISubscriptions colNodeSubscriptions = this.repository.getNodeSubscriptions(collection);
                    IAffiliations colNodeAffiliations = this.repository.getNodeAffiliations(collection);
                    result.addAll(this.prepareNotification(items, element.getAttribute("to"), nodeName, headers, colNodeConfig, colNodeAffiliations, colNodeSubscriptions));
                }
            }
            if (leafNodeConfig.isPersistItem()) {
                for (Element item : itemsToSend) {
                    String id = item.getAttribute("id");
                    this.repository.writeItem(nodeName, System.currentTimeMillis(), id, element.getAttribute("from"), item);
                }
                if (leafNodeConfig.getMaxItems() != null) {
                    this.trimItems(nodeName, leafNodeConfig.getMaxItems());
                }
            }
            return result;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void trimItems(String nodeName, Integer maxItems) throws RepositoryException {
        String[] ids = this.repository.getItemsIds(nodeName);
        if (ids == null || ids.length <= maxItems) {
            return;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (String id : ids) {
            Date updateDate = this.repository.getItemUpdateDate(nodeName, id);
            if (updateDate == null) continue;
            Item i = new Item(id, updateDate);
            items.add(i);
        }
        Collections.sort(items, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o2.updateDate.compareTo(o1.updateDate);
            }
        });
        for (int i = maxItems.intValue(); i < items.size(); ++i) {
            Item it = (Item)items.get(i);
            this.repository.deleteItem(nodeName, it.id);
        }
    }

    private static class Item {
        final String id;
        final Date updateDate;

        Item(String id, Date date) {
            this.updateDate = date;
            this.id = id;
        }
    }
}

