/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.SubscribeNodeModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.inmemory.NodeAffiliation;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class PendingSubscriptionModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"message").add((Criteria)ElementCriteria.name((String)"x", (String[])new String[]{"xmlns", "type"}, (String[])new String[]{"jabber:x:data", "submit"})).add((Criteria)ElementCriteria.name((String)"field", (String[])new String[]{"var"}, (String[])new String[]{"FORM_TYPE"})).add((Criteria)ElementCriteria.name((String)"value", (String)"http://jabber.org/protocol/pubsub#subscribe_authorization", null, null));

    public PendingSubscriptionModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#get-pending"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element message) throws PubSubException {
        try {
            NodeAffiliation senderAffiliation;
            Form x = new Form(message.getChild("x", "jabber:x:data"));
            String subId = x.getAsString("pubsub#subid");
            String node = x.getAsString("pubsub#node");
            String subscriberJid = x.getAsString("pubsub#subscriber_jid");
            Boolean allow = x.getAsBoolean("pubsub#allow");
            if (allow == null) {
                return null;
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(node);
            if (nodeConfig == null) {
                throw new PubSubException(message, Authorization.ITEM_NOT_FOUND);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(node);
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(node);
            String jid = message.getAttribute("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)jid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(jid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(message, Authorization.FORBIDDEN);
            }
            String userSubId = nodeSubscriptions.getSubscriptionId(subscriberJid);
            if (subId != null && !subId.equals(userSubId)) {
                throw new PubSubException(message, Authorization.NOT_ACCEPTABLE, PubSubErrorCondition.INVALID_SUBID);
            }
            Subscription subscription = nodeSubscriptions.getSubscription(subscriberJid);
            if (subscription != Subscription.pending) {
                return null;
            }
            Affiliation affiliation = nodeAffiliations.getSubscriberAffiliation(jid).getAffiliation();
            if (allow.booleanValue()) {
                subscription = Subscription.subscribed;
                affiliation = Affiliation.member;
                nodeSubscriptions.changeSubscription(subscriberJid, subscription);
                nodeAffiliations.changeAffiliation(subscriberJid, affiliation);
            } else {
                subscription = Subscription.none;
                nodeSubscriptions.changeSubscription(subscriberJid, subscription);
            }
            if (nodeSubscriptions.isChanged()) {
                this.repository.update(node, nodeSubscriptions);
            }
            if (nodeAffiliations.isChanged()) {
                this.repository.update(node, nodeAffiliations);
            }
            Element msg = new Element("message", new String[]{"from", "to", "id"}, new String[]{message.getAttribute("to"), subscriberJid, Utils.createUID()});
            msg.addChild(SubscribeNodeModule.makeSubscription(node, subscriberJid, subscription, null));
            return PendingSubscriptionModule.makeArray(msg);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public List<Element> sendAuthorizationRequest(String nodeName, String fromJid, String subID, String subscriberJid, IAffiliations nodeAffiliations) throws RepositoryException {
        Form x = new Form("form", "PubSub subscriber request", "To approve this entity's subscription request, click the OK button. To deny the request, click the cancel button.");
        x.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#subscribe_authorization"));
        x.addField(Field.fieldHidden((String)"pubsub#subid", (String)subID));
        x.addField(Field.fieldTextSingle((String)"pubsub#node", (String)nodeName, (String)"Node ID"));
        x.addField(Field.fieldJidSingle((String)"pusub#subscriber_jid", (String)subscriberJid, (String)"Subscriber Address"));
        x.addField(Field.fieldBoolean((String)"pubsub#allow", (Boolean)Boolean.FALSE, (String)"Allow this JID to subscribe to this pubsub node?"));
        ArrayList<Element> result = new ArrayList<Element>();
        NodeAffiliation[] affiliations = nodeAffiliations.getAffiliations();
        if (affiliations != null) {
            for (NodeAffiliation affiliation : affiliations) {
                if (affiliation.getAffiliation() != Affiliation.owner) continue;
                Element message = new Element("message", new String[]{"id", "to", "from"}, new String[]{Utils.createUID(), affiliation.getJid(), fromJid});
                message.addChild(x.getElement());
                result.add(message);
            }
        }
        return result;
    }
}

