/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AbstractConfigCreateNode;
import tigase.pubsub.modules.NodeConfigListener;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.inmemory.NodeAffiliation;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class NodeConfigModule
extends AbstractConfigCreateNode {
    private static final Criteria CRIT_CONFIG = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"configure"));
    private final ArrayList<NodeConfigListener> nodeConfigListeners = new ArrayList();
    private final PublishItemModule publishModule;

    protected static String[] diff(String[] a, String[] b) {
        HashSet<String> r = new HashSet<String>();
        for (String $a : a) {
            r.add($a);
        }
        for (String $a : b) {
            r.add($a);
        }
        for (String $a : b) {
            r.remove($a);
        }
        return r.toArray(new String[0]);
    }

    public static void parseConf(AbstractNodeConfig conf, Element configure) throws PubSubException {
        Element x = configure.getChild("x", "jabber:x:data");
        Form foo = new Form(x);
        System.out.println(foo);
        if (x != null && "submit".equals(x.getAttribute("type"))) {
            for (Field field : conf.getForm().getAllFields()) {
                String var = field.getVar();
                Field cf = foo.get(var);
                if (cf == null) continue;
                field.setValues(cf.getValues());
            }
        }
    }

    public NodeConfigModule(PubSubConfig config, IPubSubRepository pubsubRepository, LeafNodeConfig defaultNodeConfig, PublishItemModule publishItemModule) {
        super(config, pubsubRepository, defaultNodeConfig);
        this.publishModule = publishItemModule;
    }

    public void addNodeConfigListener(NodeConfigListener listener) {
        this.nodeConfigListeners.add(listener);
    }

    protected void fireOnNodeConfigChange(String nodeName) {
        for (NodeConfigListener listener : this.nodeConfigListeners) {
            listener.onNodeConfigChanged(nodeName);
        }
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#config-node"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_CONFIG;
    }

    protected boolean isIn(String node, String[] children) {
        if (node == null | children == null) {
            return false;
        }
        for (String x : children) {
            if (!x.equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        try {
            NodeAffiliation senderAffiliation;
            Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element configure = pubSub.getChild("configure");
            String nodeName = configure.getAttribute("node");
            String type = element.getAttribute("type");
            String id = element.getAttribute("id");
            System.out.println(id);
            if (nodeName == null) {
                throw new PubSubException(element, Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            String jid = element.getAttribute("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)jid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(jid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            Element result = NodeConfigModule.createResultIQ(element);
            List<Element> resultArray = NodeConfigModule.makeArray(result);
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
            if ("get".equals(type)) {
                Element rPubSub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
                Element rConfigure = new Element("configure", new String[]{"node"}, new String[]{nodeName});
                rConfigure.addChild(nodeConfig.getFormElement());
                rPubSub.addChild(rConfigure);
                result.addChild(rPubSub);
            } else if ("set".equals(type)) {
                String[] children = nodeConfig.getChildren() == null ? new String[]{} : Arrays.copyOf(nodeConfig.getChildren(), nodeConfig.getChildren().length);
                String collectionOld = nodeConfig.getCollection() == null ? "" : nodeConfig.getCollection();
                NodeConfigModule.parseConf(nodeConfig, configure);
                if (!collectionOld.equals(nodeConfig.getCollection())) {
                    ISubscriptions colNodeSubscriptions;
                    IAffiliations colNodeAffiliations;
                    AbstractNodeConfig colNodeConfig;
                    if (collectionOld.equals("")) {
                        colNodeConfig = this.repository.getNodeConfig(nodeConfig.getCollection());
                        if (colNodeConfig == null) {
                            throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#1) Node '" + nodeConfig.getCollection() + "' doesn't exists");
                        }
                        if (!(colNodeConfig instanceof CollectionNodeConfig)) {
                            throw new PubSubException(Authorization.NOT_ALLOWED, "(#1) Node '" + nodeConfig.getCollection() + "' is not collection node");
                        }
                        ((CollectionNodeConfig)colNodeConfig).addChildren(nodeName);
                        this.repository.update(colNodeConfig.getNodeName(), colNodeConfig);
                        this.repository.removeFromRootCollection(nodeName);
                        colNodeAffiliations = this.repository.getNodeAffiliations(colNodeConfig.getNodeName());
                        colNodeSubscriptions = this.repository.getNodeSubscriptions(colNodeConfig.getNodeName());
                        Element associateNotification = this.createAssociateNotification(colNodeConfig.getNodeName(), nodeName);
                        resultArray.addAll(this.publishModule.prepareNotification(associateNotification, element.getAttribute("to"), nodeName, nodeConfig, colNodeAffiliations, colNodeSubscriptions));
                    }
                    if (nodeConfig.getCollection().equals("")) {
                        colNodeConfig = this.repository.getNodeConfig(collectionOld);
                        if (colNodeConfig != null && colNodeConfig instanceof CollectionNodeConfig) {
                            ((CollectionNodeConfig)colNodeConfig).removeChildren(nodeName);
                            this.repository.update(colNodeConfig.getNodeName(), colNodeConfig);
                        }
                        this.repository.addToRootCollection(nodeName);
                        colNodeAffiliations = this.repository.getNodeAffiliations(colNodeConfig.getNodeName());
                        colNodeSubscriptions = this.repository.getNodeSubscriptions(colNodeConfig.getNodeName());
                        Element disassociateNotification = this.createDisassociateNotification(collectionOld, nodeName);
                        resultArray.addAll(this.publishModule.prepareNotification(disassociateNotification, element.getAttribute("to"), nodeName, nodeConfig, colNodeAffiliations, colNodeSubscriptions));
                    }
                }
                if (nodeConfig instanceof CollectionNodeConfig) {
                    AbstractNodeConfig nc;
                    String[] addedChildNodes;
                    String[] removedChildNodes = NodeConfigModule.diff(children == null ? new String[]{} : children, nodeConfig.getChildren() == null ? new String[]{} : nodeConfig.getChildren());
                    for (String ann : addedChildNodes = NodeConfigModule.diff(nodeConfig.getChildren() == null ? new String[]{} : nodeConfig.getChildren(), children == null ? new String[]{} : children)) {
                        nc = this.repository.getNodeConfig(ann);
                        if (nc == null) {
                            throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#2) Node '" + ann + "' doesn't exists");
                        }
                        if (nc.getCollection().equals("")) {
                            this.repository.removeFromRootCollection(nc.getNodeName());
                        } else {
                            AbstractNodeConfig cnc = this.repository.getNodeConfig(nc.getCollection());
                            if (cnc == null) {
                                throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#3) Node '" + nc.getCollection() + "' doesn't exists");
                            }
                            if (!(cnc instanceof CollectionNodeConfig)) {
                                throw new PubSubException(Authorization.NOT_ALLOWED, "(#2) Node '" + nc.getCollection() + "' is not collection node");
                            }
                            ((CollectionNodeConfig)cnc).removeChildren(nc.getNodeName());
                            this.repository.update(cnc.getNodeName(), cnc);
                        }
                        nc.setCollection(nodeName);
                        this.repository.update(nc.getNodeName(), nc);
                        Element associateNotification = this.createAssociateNotification(nodeName, ann);
                        resultArray.addAll(this.publishModule.prepareNotification(associateNotification, element.getAttribute("to"), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
                    }
                    for (String rnn : removedChildNodes) {
                        nc = this.repository.getNodeConfig(rnn);
                        if (nc != null) {
                            nc.setCollection("");
                            this.repository.update(nc.getNodeName(), nc);
                        }
                        if (rnn == null || rnn.length() == 0) continue;
                        Element disassociateNotification = this.createDisassociateNotification(nodeName, rnn);
                        resultArray.addAll(this.publishModule.prepareNotification(disassociateNotification, element.getAttribute("to"), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
                    }
                }
                this.repository.update(nodeName, nodeConfig);
                if (nodeConfig.isNotify_config()) {
                    String pssJid = element.getAttribute("to");
                    Element configuration = new Element("configuration", new String[]{"node"}, new String[]{nodeName});
                    resultArray.addAll(this.publishModule.prepareNotification(configuration, pssJid, nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
                }
            } else {
                throw new PubSubException(element, Authorization.BAD_REQUEST);
            }
            return resultArray;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Element createDisassociateNotification(String collectionNodeName, String disassociatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild(new Element("disassociate", new String[]{"node"}, new String[]{disassociatedNodeName}));
        return colE;
    }

    private Element createAssociateNotification(String collectionNodeName, String associatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild(new Element("associate", new String[]{"node"}, new String[]{associatedNodeName}));
        return colE;
    }

    public void removeNodeConfigListener(NodeConfigListener listener) {
        this.nodeConfigListeners.remove(listener);
    }
}

