/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.inmemory.NodeAffiliation;
import tigase.pubsub.repository.inmemory.Subscriber;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class ManageSubscriptionModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"subscriptions"));

    private static Element createAffiliationNotification(String fromJid, String toJid, String nodeName, Subscription subscription) {
        Element message = new Element("message", new String[]{"from", "to"}, new String[]{fromJid, toJid});
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        message.addChild(pubsub);
        Element affilations = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        pubsub.addChild(affilations);
        affilations.addChild(new Element("subscription", new String[]{"jid", "subscription"}, new String[]{toJid, subscription.name()}));
        return message;
    }

    public ManageSubscriptionModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#manage-subscriptions"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws PubSubException {
        try {
            NodeAffiliation senderAffiliation;
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element subscriptions = pubsub.getChild("subscriptions");
            String nodeName = subscriptions.getAttribute("node");
            String type = element.getAttribute("type");
            if (type == null || !type.equals("get") && !type.equals("set")) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(nodeName);
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(nodeName);
            String senderJid = element.getAttribute("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            List<Object> result = new ArrayList();
            if (type.equals("get")) {
                result = this.processGet(element, subscriptions, nodeName, nodeSubscriptions);
            } else if (type.equals("set")) {
                result = this.processSet(element, subscriptions, nodeName, nodeSubscriptions);
            }
            if (nodeSubscriptions.isChanged()) {
                this.repository.update(nodeName, nodeSubscriptions);
            }
            return result;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<Element> processGet(Element element, Element subscriptions, String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        ArrayList<Element> result = new ArrayList<Element>();
        Element iq = ManageSubscriptionModule.createResultIQ(element);
        Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
        iq.addChild(ps);
        Element afr = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        ps.addChild(afr);
        Subscriber[] subscribers = nodeSubscriptions.getSubscriptions();
        if (subscribers != null) {
            for (Subscriber subscriber : subscribers) {
                if (subscriber.getSubscription() == Subscription.none) continue;
                Element subscription = new Element("subscription", new String[]{"jid", "subscription"}, new String[]{subscriber.getJid(), subscriber.getSubscription().name()});
                afr.addChild(subscription);
            }
        }
        result.add(iq);
        return result;
    }

    private List<Element> processSet(Element element, Element subscriptions, String nodeName, ISubscriptions nodeSubscriptions) throws PubSubException, RepositoryException {
        ArrayList<Element> result = new ArrayList<Element>();
        Element iq = ManageSubscriptionModule.createResultIQ(element);
        result.add(iq);
        List subss = subscriptions.getChildren();
        for (Element a : subss) {
            if ("subscription".equals(a.getName())) continue;
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        for (Element af : subss) {
            String strSubscription = af.getAttribute("subscription");
            String jid = af.getAttribute("jid");
            if (strSubscription == null) continue;
            Subscription newSubscription = Subscription.valueOf(strSubscription);
            Subscription oldSubscription = nodeSubscriptions.getSubscription(jid);
            Subscription subscription = oldSubscription = oldSubscription == null ? Subscription.none : oldSubscription;
            if (oldSubscription == Subscription.none && newSubscription != Subscription.none) {
                nodeSubscriptions.addSubscriberJid(jid, newSubscription);
                result.add(ManageSubscriptionModule.createAffiliationNotification(element.getAttribute("to"), jid, nodeName, newSubscription));
                continue;
            }
            nodeSubscriptions.changeSubscription(jid, newSubscription);
            result.add(ManageSubscriptionModule.createAffiliationNotification(element.getAttribute("to"), jid, nodeName, newSubscription));
        }
        return result;
    }
}

