/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.security.SecureRandom;
import java.util.logging.Logger;
import tigase.util.JIDUtils;

public class Utils {
    private static final String CHARSET = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static Logger log = Logger.getLogger(Utils.class.getName());
    private static SecureRandom numberGenerator;

    public static String asString(String ... array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            sb.append("[");
            for (String string : array) {
                sb.append("'");
                sb.append(string);
                sb.append("', ");
            }
            sb.append("]");
        } else {
            sb.append("[null]");
        }
        return sb.toString();
    }

    public static boolean contain(String string, String ... array) {
        for (String s : array) {
            if ((s != null || string != null) && (s == null || string == null || !string.equals(s))) continue;
            return true;
        }
        return false;
    }

    public static synchronized String createUID() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        String result = "";
        for (int i = 0; i < 16; ++i) {
            int a = ng.nextInt(CHARSET.length());
            result = result + CHARSET.charAt(a);
        }
        return result;
    }

    public static boolean isAllowedDomain(String jid, String ... domains) {
        log.finer("Checking is " + jid + " allowed to see domains: " + Utils.asString(domains));
        if (jid == null || domains == null || domains.length == 0) {
            return true;
        }
        String jidHost = JIDUtils.getNodeHost((String)jid);
        for (String d : domains) {
            if (!jidHost.equals(d)) continue;
            return true;
        }
        return false;
    }

    private Utils() {
    }
}

