/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.criteria.Criteria;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.DefaultNodeConfigListener;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.Module;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AdHocConfigCommandModule;
import tigase.pubsub.modules.DefaultConfigModule;
import tigase.pubsub.modules.DiscoverInfoModule;
import tigase.pubsub.modules.DiscoverItemsModule;
import tigase.pubsub.modules.JabberVersionModule;
import tigase.pubsub.modules.ManageAffiliationsModule;
import tigase.pubsub.modules.ManageSubscriptionModule;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.pubsub.modules.NodeCreateModule;
import tigase.pubsub.modules.NodeDeleteModule;
import tigase.pubsub.modules.PendingSubscriptionModule;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.PurgeItemsModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.modules.RetrieveAffiliationsModule;
import tigase.pubsub.modules.RetrieveItemsModule;
import tigase.pubsub.modules.RetrieveSubscriptionsModule;
import tigase.pubsub.modules.SubscribeNodeModule;
import tigase.pubsub.modules.UnsubscribeNodeModule;
import tigase.pubsub.modules.XmppPingModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.modules.commands.DefaultConfigCommand;
import tigase.pubsub.modules.commands.DeleteAllNodesCommand;
import tigase.pubsub.modules.commands.RebuildDatabaseCommand;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.stateless.StatelessPubSubRepository;
import tigase.server.AbstractMessageReceiver;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class PubSubComponent
extends AbstractMessageReceiver
implements XMPPService,
Configurable,
DisableDisco,
DefaultNodeConfigListener {
    public static final String ADMINS_KEY = "admin";
    public static final String DEFAULT_LEAF_NODE_CONFIG_KEY = "default-node-config";
    protected static final String PUBSUB_REPO_CLASS_PROP_KEY = "pubsub-repo-class";
    protected static final String PUBSUB_REPO_URL_PROP_KEY = "pubsub-repo-url";
    protected AdHocConfigCommandModule adHocCommandsModule;
    protected final PubSubConfig config = new PubSubConfig();
    protected DefaultConfigModule defaultConfigModule;
    protected LeafNodeConfig defaultNodeConfig;
    private PubSubDAO directPubSubRepository;
    public String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private ManageAffiliationsModule manageAffiliationsModule;
    private ManageSubscriptionModule manageSubscriptionModule;
    private final ArrayList<Module> modules = new ArrayList();
    protected NodeConfigModule nodeConfigModule;
    protected NodeCreateModule nodeCreateModule;
    protected NodeDeleteModule nodeDeleteModule;
    private PendingSubscriptionModule pendingSubscriptionModule;
    protected PresenceCollectorModule presenceCollectorModule;
    protected PublishItemModule publishNodeModule;
    protected IPubSubRepository pubsubRepository;
    private PurgeItemsModule purgeItemsModule;
    protected RetractItemModule retractItemModule;
    private RetrieveItemsModule retrirveItemsModule;
    protected ServiceEntity serviceEntity;
    protected AbstractModule subscribeNodeModule;
    protected UnsubscribeNodeModule unsubscribeNodeModule;
    private UserRepository userRepository;
    protected XsltTool xslTransformer;

    public PubSubComponent() {
        this.setName("pubsub");
    }

    protected IPubSubRepository createPubSubRepository(PubSubDAO directRepository) {
        return new StatelessPubSubRepository(directRepository, this.config);
    }

    protected String extractNodeName(Element element) {
        if (element == null) {
            return null;
        }
        Element ps = element.getChild("pubsub");
        Element query = element.getChild("query");
        if (ps != null) {
            List children = ps.getChildren();
            if (children != null) {
                for (Element e : children) {
                    String n = e.getAttribute("node");
                    if (n == null) continue;
                    return n;
                }
            }
        } else if (query != null) {
            String n = query.getAttribute("node");
            return n;
        }
        return null;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        String[] hostnames = new String[this.HOSTNAMES_PROP_VAL.length];
        int i = 0;
        for (String host : this.HOSTNAMES_PROP_VAL) {
            hostnames[i++] = this.getName() + "." + host;
        }
        props.put("hostnames", hostnames);
        String repo_class = "tigase.db.xml.XMLRepository";
        String repo_uri = "user-repository.xml";
        String conf_db = null;
        if (params.get("--user-db") != null) {
            conf_db = (String)params.get("--user-db");
        }
        if (conf_db != null) {
            if (conf_db.equals("mysql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (conf_db.equals("pgsql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
        }
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        props.put(PUBSUB_REPO_CLASS_PROP_KEY, repo_class);
        props.put(PUBSUB_REPO_URL_PROP_KEY, repo_uri);
        String[] admins = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@" + this.getDefHostName()};
        props.put(ADMINS_KEY, admins);
        return props;
    }

    public List<Element> getDiscoFeatures() {
        System.out.println("GET DISCO FEATORUES");
        return null;
    }

    public Element getDiscoInfo(String node, String jid) {
        return null;
    }

    public List<Element> getDiscoItems(String node, String jid) {
        Element result = this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid);
        return Arrays.asList(result);
    }

    protected void init() {
        this.xslTransformer = new XsltTool();
        this.presenceCollectorModule = this.registerModule(new PresenceCollectorModule());
        this.publishNodeModule = this.registerModule(new PublishItemModule(this.config, this.pubsubRepository, this.xslTransformer, this.presenceCollectorModule));
        this.retractItemModule = this.registerModule(new RetractItemModule(this.config, this.pubsubRepository, this.publishNodeModule));
        this.pendingSubscriptionModule = this.registerModule(new PendingSubscriptionModule(this.config, this.pubsubRepository));
        this.manageSubscriptionModule = this.registerModule(new ManageSubscriptionModule(this.config, this.pubsubRepository));
        this.subscribeNodeModule = this.registerModule(new SubscribeNodeModule(this.config, this.pubsubRepository, this.pendingSubscriptionModule));
        this.nodeCreateModule = this.registerModule(new NodeCreateModule(this.config, this.pubsubRepository, this.defaultNodeConfig, this.publishNodeModule));
        this.nodeDeleteModule = this.registerModule(new NodeDeleteModule(this.config, this.pubsubRepository, this.publishNodeModule));
        this.defaultConfigModule = this.registerModule(new DefaultConfigModule(this.config, this.pubsubRepository, this.defaultNodeConfig));
        this.nodeConfigModule = this.registerModule(new NodeConfigModule(this.config, this.pubsubRepository, this.defaultNodeConfig, this.publishNodeModule));
        this.unsubscribeNodeModule = this.registerModule(new UnsubscribeNodeModule(this.config, this.pubsubRepository));
        this.manageAffiliationsModule = this.registerModule(new ManageAffiliationsModule(this.config, this.pubsubRepository));
        this.retrirveItemsModule = this.registerModule(new RetrieveItemsModule(this.config, this.pubsubRepository));
        this.purgeItemsModule = this.registerModule(new PurgeItemsModule(this.config, this.pubsubRepository, this.publishNodeModule));
        this.registerModule(new JabberVersionModule());
        this.adHocCommandsModule = this.registerModule(new AdHocConfigCommandModule(this.config, this.pubsubRepository));
        this.registerModule(new DiscoverInfoModule(this.config, this.pubsubRepository, this.modules));
        this.registerModule(new DiscoverItemsModule(this.config, this.pubsubRepository, this.adHocCommandsModule));
        this.registerModule(new RetrieveAffiliationsModule(this.config, this.pubsubRepository));
        this.registerModule(new RetrieveSubscriptionsModule(this.config, this.pubsubRepository));
        this.registerModule(new XmppPingModule());
        this.pubsubRepository.init();
    }

    public String myDomain() {
        return this.getName() + "." + this.getDefHostName();
    }

    @Override
    public void onChangeDefaultNodeConfig() {
        try {
            this.defaultNodeConfig.read(this.userRepository, this.config, DEFAULT_LEAF_NODE_CONFIG_KEY);
            this.log.info("Node " + this.getComponentId() + " read default node configuration.");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Reading default config error", e);
        }
    }

    public void processPacket(Packet packet) {
        this.log.finest("Received by " + this.getComponentId() + ": " + packet.getElement().toString());
        try {
            Element element = packet.getElement();
            boolean handled = this.runModules(element);
            if (!handled) {
                StanzaType type = packet.getType();
                if (type != StanzaType.error) {
                    this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Stanza is not processed", true));
                } else {
                    this.log.finer(packet.getElemName() + " stanza with type='error' ignored");
                }
            }
        }
        catch (PubSubException e) {
            Element result = e.makeElement(packet.getElement());
            this.addOutPacket(new Packet(result));
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unexpected exception: internal-server-error", e);
            e.printStackTrace();
            try {
                this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, e.getMessage(), true));
            }
            catch (PacketErrorTypeException e1) {
                e1.printStackTrace();
                this.log.throwing("PubSub Service", "processPacket (sending internal-server-error)", e);
            }
        }
    }

    public <T extends Module> T registerModule(T module) {
        this.log.config("Register PubSub plugin: " + module.getClass().getCanonicalName());
        this.modules.add(module);
        return module;
    }

    protected boolean runModules(Element element) throws PubSubException {
        boolean handled = false;
        this.log.finest("Processing packet: " + element.toString());
        for (Module module : this.modules) {
            Criteria criteria = module.getModuleCriteria();
            if (criteria == null || !criteria.match(element)) continue;
            handled = true;
            this.log.finest("Handled by module " + module.getClass());
            List<Element> result = module.process(element);
            if (result == null) continue;
            for (Element e : result) {
                this.addOutPacket(new Packet(e));
            }
            return true;
        }
        return handled;
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        String[] hostnames = (String[])props.get("hostnames");
        if (hostnames == null || hostnames.length == 0) {
            this.log.warning("Hostnames definition is empty, setting 'localhost'");
            hostnames = new String[]{this.getName() + ".localhost"};
        }
        this.clearRoutings();
        for (String host : hostnames) {
            this.addRouting(host);
        }
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Publish-Subscribe");
        this.serviceEntity.addIdentities(new ServiceIdentity[]{new ServiceIdentity("pubsub", "service", "Publish-Subscribe")});
        this.serviceEntity.addFeatures(new String[]{"http://jabber.org/protocol/pubsub"});
        this.config.setAdmins((String[])props.get(ADMINS_KEY));
        this.config.setServiceName("tigase-pubsub");
        try {
            String cls_name = (String)props.get(PUBSUB_REPO_CLASS_PROP_KEY);
            String res_uri = (String)props.get(PUBSUB_REPO_URL_PROP_KEY);
            this.userRepository = RepositoryFactory.getUserRepository((String)"pubsub", (String)cls_name, (String)res_uri, null);
            this.userRepository.initRepository(res_uri, null);
            this.directPubSubRepository = new PubSubDAO(this.userRepository, this.config);
            this.pubsubRepository = this.createPubSubRepository(this.directPubSubRepository);
            this.defaultNodeConfig = new LeafNodeConfig("default");
            this.defaultNodeConfig.read(this.userRepository, this.config, DEFAULT_LEAF_NODE_CONFIG_KEY);
            this.defaultNodeConfig.write(this.userRepository, this.config, DEFAULT_LEAF_NODE_CONFIG_KEY);
            this.log.config("Initialized " + cls_name + " as pubsub repository: " + res_uri);
        }
        catch (Exception e) {
            this.log.severe("Can't initialize pubsub repository: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        this.init();
        DefaultConfigCommand configCommand = new DefaultConfigCommand(this.config, this.userRepository);
        configCommand.addListener(this);
        this.adHocCommandsModule.register(new RebuildDatabaseCommand(this.config, this.directPubSubRepository));
        this.adHocCommandsModule.register(configCommand);
        this.adHocCommandsModule.register(new DeleteAllNodesCommand(this.config, this.directPubSubRepository, this.userRepository));
        StringBuilder sb = new StringBuilder();
        for (Module module : this.modules) {
            String[] features = module.getFeatures();
            if (features == null) continue;
            for (String f : features) {
                sb.append(f);
                sb.append('\n');
                this.serviceEntity.addFeatures(new String[]{f});
            }
        }
        this.log.config("Supported features: " + sb.toString());
    }
}

