/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusteredComponent;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.repository.RepositoryException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class PubSubClusterComponent
extends PubSubComponent
implements ClusteredComponent {
    private static final String METHOD_PRESENCE_COLLECTION = "presenceCollection";
    private static Random random = new SecureRandom();
    private final Set<String> cluster_nodes = new LinkedHashSet<String>();

    protected static String[] getParameters(String name, Map<String, String> allMethodParams) {
        ArrayList<String> nodesNames = new ArrayList<String>();
        for (Map.Entry<String, String> pps : allMethodParams.entrySet()) {
            if (!pps.getKey().startsWith(name)) continue;
            nodesNames.add(pps.getValue());
        }
        return nodesNames.toArray(new String[0]);
    }

    public PubSubClusterComponent() {
        this.log = Logger.getLogger(this.getClass().getName());
        this.log.config("PubSubCluster Component starting");
    }

    public String getComponentId() {
        String name = System.getProperty("test", "no").equals("yes") ? super.getComponentId().replace("@", ".") : super.getComponentId();
        return name;
    }

    protected String getFirstClusterNode() {
        String cluster_node = null;
        for (String node : this.cluster_nodes) {
            if (node.equals(this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }

    private String getRandomNode() {
        String[] nodes = this.cluster_nodes.toArray(new String[0]);
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        int a = random.nextInt(nodes.length);
        return nodes[a];
    }

    @Override
    protected void init() {
        if (System.getProperty("test", "no").equals("yes")) {
            HashSet<String> n = new HashSet<String>();
            n.add("pubsub.sphere");
            n.add("pubsub1.sphere");
            String msh = "********** !!!  TEST ENVIROMENT !!! **********";
            System.out.println("********** !!!  TEST ENVIROMENT !!! **********");
            this.log.config("********** !!!  TEST ENVIROMENT !!! **********");
            for (String string : n) {
                this.log.config("Test Node connected: " + string);
                this.cluster_nodes.add(string);
            }
        }
        super.init();
        this.log.config("PubSubCluster component configured.");
    }

    public void nodesConnected(Set<String> node_hostnames) {
        for (String node : node_hostnames) {
            this.log.finest("Node connected: " + node + " (" + this.getName() + "@" + node + ")");
            this.cluster_nodes.add(this.getName() + "@" + node);
            this.sendAvailableJidsToNode(this.getName() + "@" + node);
        }
    }

    public void nodesDisconnected(Set<String> node_hostnames) {
        for (String node : node_hostnames) {
            this.log.finest("Node disconnected: " + node + " (" + this.getName() + "@" + node + ")");
            this.cluster_nodes.remove(this.getName() + "@" + node);
        }
    }

    protected void processMethodCall(String methodName, Map<String, String> allMethodParams) throws RepositoryException {
        if (METHOD_PRESENCE_COLLECTION.equals(methodName)) {
            String[] jids;
            for (String jid : jids = PubSubClusterComponent.getParameters("jid", allMethodParams)) {
                this.presenceCollectorModule.addJid(jid);
            }
        }
    }

    @Override
    public void processPacket(Packet packet) {
        this.log.finest("Received by " + this.getComponentId() + ": " + packet.getElement().toString());
        if (packet.getElemName() == "cluster" || packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            this.log.finest("Handling as internal cluster message");
            ClusterElement clel = new ClusterElement(packet.getElement());
            List elements = clel.getDataPackets();
            if (clel.getMethodName() != null) {
                try {
                    this.processMethodCall(clel.getMethodName(), clel.getAllMethodParams());
                }
                catch (Exception e) {
                    this.log.throwing("PubSub Service", "processPacket (remote method call)", e);
                    e.printStackTrace();
                    try {
                        this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, e.getMessage(), true));
                    }
                    catch (PacketErrorTypeException e1) {
                        e1.printStackTrace();
                        this.log.throwing("PubSub Service", "processPacket (sending internal-server-error)", e);
                    }
                }
            } else {
                for (Element element : elements) {
                    super.processPacket(new Packet(element));
                }
            }
        } else if (this.cluster_nodes == null || this.cluster_nodes.size() == 0) {
            super.processPacket(packet);
        } else {
            Element element = packet.getElement();
            if (element.getName().equals("presence")) {
                this.sentBroadcast(packet);
            } else {
                String node = this.extractNodeName(element);
                if (node != null) {
                    String clusterNode = this.getRandomNode();
                    if (clusterNode == null || this.publishNodeModule.isPEPNodeName(node)) {
                        super.processPacket(packet);
                    } else {
                        this.log.finest("Cluster node " + this.getComponentId() + " received PubSub node '" + node + "' and sent it to cluster node [" + clusterNode + "]");
                        this.sentToNode(packet, clusterNode);
                    }
                } else {
                    this.log.finest("Cluster node " + this.getComponentId() + " received stanza without node name");
                    super.processPacket(packet);
                }
            }
        }
    }

    protected void sendAvailableJidsToNode(String node) {
        HashMap<String, String> params = new HashMap<String, String>();
        int counter = 0;
        for (String jid : this.presenceCollectorModule.getAllAvailableJids()) {
            params.put("jid." + ++counter, jid);
            if (params.size() <= 99) continue;
            ClusterElement call = ClusterElement.createClusterMethodCall((String)this.getComponentId(), (String)node, (StanzaType)StanzaType.set, (String)METHOD_PRESENCE_COLLECTION, params);
            this.addOutPacket(new Packet(call.getClusterElement()));
            params = new HashMap();
        }
        if (params.size() != 0) {
            ClusterElement call = ClusterElement.createClusterMethodCall((String)this.getComponentId(), (String)node, (StanzaType)StanzaType.set, (String)METHOD_PRESENCE_COLLECTION, params);
            this.addOutPacket(new Packet(call.getClusterElement()));
        }
    }

    protected void sentBroadcast(Packet packet) {
        this.log.finest("Send broadcast with: " + packet.toString());
        for (String cNN : this.cluster_nodes) {
            this.sentToNode(packet, cNN);
        }
    }

    protected boolean sentToNextNode(ClusterElement clel) {
        ClusterElement next_clel = ClusterElement.createForNextNode((ClusterElement)clel, this.cluster_nodes, (String)this.getComponentId());
        if (next_clel != null) {
            this.addOutPacket(new Packet(next_clel.getClusterElement()));
            return true;
        }
        return false;
    }

    protected boolean sentToNextNode(Packet packet) {
        if (this.cluster_nodes.size() > 0) {
            String sess_man_id = this.getComponentId();
            String cluster_node = this.getFirstClusterNode();
            if (cluster_node != null) {
                ClusterElement clel = new ClusterElement(sess_man_id, cluster_node, StanzaType.set, packet);
                clel.addVisitedNode(sess_man_id);
                this.log.finest("Sending packet to next node [" + cluster_node + "]");
                this.addOutPacket(new Packet(clel.getClusterElement()));
                return true;
            }
        }
        return false;
    }

    protected boolean sentToNode(Packet packet, String cluster_node) {
        if (cluster_node.equals(this.getComponentId())) {
            super.processPacket(packet);
        } else if (this.cluster_nodes.size() > 0) {
            String sess_man_id = this.getComponentId();
            if (cluster_node != null) {
                ClusterElement clel = new ClusterElement(sess_man_id, cluster_node, StanzaType.set, packet);
                clel.addVisitedNode(sess_man_id);
                this.log.finest("Sending packet to next node [" + cluster_node + "]");
                this.addOutPacket(new Packet(clel.getClusterElement()));
                return true;
            }
        }
        return false;
    }
}

