/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

public class ElementCache<E> {
    private E data;
    private final long maxTimeToLive;
    private long readTimestamp;
    private long updateTimestamp;

    public ElementCache(long maxTimeToLive) {
        this.maxTimeToLive = maxTimeToLive;
    }

    public E getData() {
        long now = System.currentTimeMillis();
        if (this.updateTimestamp + this.maxTimeToLive <= now) {
            this.data = null;
        } else {
            this.readTimestamp = System.currentTimeMillis();
        }
        return this.data;
    }

    public void setData(E data) {
        this.data = data;
        this.readTimestamp = this.updateTimestamp = System.currentTimeMillis();
    }
}

