/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.Module;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.inmemory.NodeAffiliation;
import tigase.pubsub.repository.inmemory.Subscriber;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public abstract class AbstractModule
implements Module {
    protected final PubSubConfig config;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected final IPubSubRepository repository;

    public static Element createResultIQ(Element iq) {
        return new Element("iq", new String[]{"type", "from", "to", "id"}, new String[]{"result", iq.getAttribute("to"), iq.getAttribute("from"), iq.getAttribute("id")});
    }

    public static List<Element> createResultIQArray(Element iq) {
        return AbstractModule.makeArray(AbstractModule.createResultIQ(iq));
    }

    public static List<Element> makeArray(Element ... elements) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : elements) {
            result.add(element);
        }
        return result;
    }

    public AbstractModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        this.config = config;
        this.repository = pubsubRepository;
    }

    protected String findBestJid(String[] allSubscribers, String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        String best = null;
        for (String j : allSubscribers) {
            if (j.equals(jid)) {
                return j;
            }
            if (!bareJid.equals(j)) continue;
            best = j;
        }
        return best;
    }

    public String[] getActiveSubscribers(IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        Subscriber[] subscribers = subscriptions.getSubscriptions();
        if (subscribers == null) {
            return new String[0];
        }
        String[] jids = new String[subscribers.length];
        for (int i = 0; i < subscribers.length; ++i) {
            jids[i] = subscribers[i].getJid();
        }
        return this.getActiveSubscribers(jids, affiliations, subscriptions);
    }

    public String[] getActiveSubscribers(String[] jids, IAffiliations affiliations, ISubscriptions subscriptions) {
        ArrayList<String> result = new ArrayList<String>();
        if (jids != null) {
            for (String jid : jids) {
                Subscription subscription;
                NodeAffiliation affiliation = affiliations.getSubscriberAffiliation(jid);
                if (affiliation.getAffiliation() == Affiliation.outcast || (subscription = subscriptions.getSubscription(jid)) != Subscription.subscribed) continue;
                result.add(jid);
            }
        }
        return result.toArray(new String[0]);
    }

    protected boolean hasSenderSubscription(String jid, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        Subscriber[] subscribers = subscriptions.getSubscriptions();
        String bareJid = JIDUtils.getNodeID((String)jid);
        for (Subscriber owner : subscribers) {
            String[] buddies;
            NodeAffiliation affiliation = affiliations.getSubscriberAffiliation(owner.getJid());
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals(owner)) {
                return true;
            }
            for (String buddy : buddies = this.repository.getUserRoster(owner.getJid())) {
                String s;
                if (!bareJid.equals(buddy) || (s = this.repository.getBuddySubscription(owner.getJid(), bareJid)) == null || !"from".equals(s) && !"both".equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSenderInRosterGroup(String jid, AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        Subscriber[] subscribers = subscriptions.getSubscriptions();
        String bareJid = JIDUtils.getNodeID((String)jid);
        String[] groupsAllowed = nodeConfig.getRosterGroupsAllowed();
        if (groupsAllowed == null || groupsAllowed.length == 0) {
            return true;
        }
        for (Subscriber owner : subscribers) {
            String[] buddies;
            NodeAffiliation affiliation = affiliations.getSubscriberAffiliation(owner.getJid());
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals(owner)) {
                return true;
            }
            for (String buddy : buddies = this.repository.getUserRoster(owner.getJid())) {
                String[] groups;
                if (!bareJid.equals(buddy)) continue;
                for (String group : groups = this.repository.getBuddyGroups(owner.getJid(), bareJid)) {
                    if (!Utils.contain(group, groupsAllowed)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

