/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository.derby;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import tigase.util.Algorithms;

public class StoredProcedures {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static void migrateFromOldSchema() throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            ResultSet rs;
            Statement stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery("select persistent from tig_muc_room_affiliations where room_id = 0");
                rs.close();
            }
            catch (SQLException ex) {
                stmt.execute("alter table tig_muc_room_affiliations add column persistent int default 0");
            }
            try {
                rs = stmt.executeQuery("select nickname from tig_muc_room_affiliations where room_id = 0");
                rs.close();
            }
            catch (SQLException ex) {
                stmt.execute("alter table tig_muc_room_affiliations add column nickname varchar(1024)");
            }
            try {
                rs = stmt.executeQuery("select avatar_hash from tig_muc_rooms where room_id = 0");
                rs.close();
            }
            catch (SQLException ex) {
                stmt.execute("alter table tig_muc_rooms add avatar clob");
                stmt.execute("alter table tig_muc_rooms add avatar_hash varchar(42)");
            }
        }
    }

    protected static String sha1OfLower(String data) throws SQLException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(data.toLowerCase().getBytes(UTF8));
            return Algorithms.bytesToHex((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(e);
        }
    }

    public static void tigMucAddMessage(String roomJid, String stableId, Timestamp ts, String senderJid, String senderNick, String body, Boolean publicEvent, String msg) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("insert into tig_muc_room_history (room_jid, room_jid_sha1, event_type, ts, sender_jid, sender_nickname, body, public_event, msg, stable_id) values (?, ?, 1, ?, ?, ?, ?, ?, ?, ?)");
            ps.setString(1, roomJid);
            ps.setString(2, StoredProcedures.sha1OfLower(roomJid));
            ps.setTimestamp(3, ts);
            ps.setString(4, senderJid);
            ps.setString(5, senderNick);
            ps.setString(6, body);
            ps.setBoolean(7, publicEvent);
            ps.setString(8, msg);
            ps.setString(9, stableId);
            ps.executeUpdate();
        }
    }

    public static void tigMucCreateRoom(String roomJid, String creatorJid, Timestamp creationDate, String roomName, String roomConfig, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("insert into tig_muc_rooms (jid, jid_sha1, name, config, creator, creation_date) values (?, ?, ?, ?, ?, ?)", 1);
            ps.setString(1, roomJid);
            ps.setString(2, StoredProcedures.sha1OfLower(roomJid));
            ps.setString(3, roomName);
            ps.setString(4, roomConfig);
            ps.setString(5, creatorJid);
            ps.setTimestamp(6, creationDate);
            ps.executeUpdate();
            data[0] = ps.getGeneratedKeys();
        }
    }

    public static void tigMucDeleteMessages(String roomJid) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_muc_room_history where room_jid_sha1 = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            ps.executeUpdate();
        }
    }

    public static void tigMucDestroyRoom(String roomJid) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String roomJidSha1 = StoredProcedures.sha1OfLower(roomJid);
            PreparedStatement ps = conn.prepareStatement("select room_id from tig_muc_rooms where jid_sha1 = ?");
            ps.setString(1, roomJidSha1);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                return;
            }
            long roomId = rs.getLong(1);
            ps = conn.prepareStatement("delete from tig_muc_room_affiliations where room_id = ?");
            ps.setLong(1, roomId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_muc_rooms where room_id = ?");
            ps.setLong(1, roomId);
            ps.executeUpdate();
        }
    }

    public static void tigMucGetAvatar(Long id, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select avatar from tig_muc_rooms where room_id = ?");
            ps.setLong(1, id);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucGetMessage(String roomJid, String stableId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select h.sender_nickname, h.stable_id, h.ts, h.sender_jid, h.body, h.msg from tig_muc_room_history h where h.room_jid_sha1 = ?\tand h.stable_id = ? order by h.ts desc");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            ps.setString(2, stableId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucGetMessages(String roomJid, Integer maxMessages, Timestamp since, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select t.sender_nickname, t.stable_id, t.ts, t.sender_jid, t.body, t.msg from (select h.sender_nickname, h.stable_id, h.ts, h.sender_jid, h.body, h.msg from tig_muc_room_history h where h.room_jid_sha1 = ?\tand (? is null or h.ts >= ?) order by h.ts desc offset 0 rows fetch next ? rows only) AS t order by t.ts asc");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            ps.setTimestamp(2, since);
            ps.setTimestamp(3, since);
            ps.setInt(4, maxMessages);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucGetRoom(String roomJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select room_id, creation_date, creator, config, subject, subject_creator_nick, subject_date, avatar_hash from tig_muc_rooms where jid_sha1 = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucGetRoomAffiliations(Long roomId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select jid, affiliation, persistent, nickname from tig_muc_room_affiliations where room_id = ?");
            ps.setLong(1, roomId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucGetRoomsJids(ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select jid from tig_muc_rooms");
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucMamGetMessagePosition(String roomJid, Timestamp since, Timestamp to, String nickname, String stableId, ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        ResultSet rs = null;
        try {
            Timestamp id_ts = null;
            PreparedStatement ps = conn.prepareStatement("select h.ts from tig_muc_room_history h where h.room_jid_sha1 = ? and h.stable_id = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            ps.setString(2, stableId);
            rs = ps.executeQuery();
            if (rs.next()) {
                id_ts = rs.getTimestamp(1);
            }
            rs.close();
            rs = null;
            ps = conn.prepareStatement("select count(1) from tig_muc_room_history h where h.room_jid_sha1 = ?\tand (? is null or h.ts >= ?)\tand (? is null or h.ts <= ?)\tand (? is null or h.sender_nickname = ?)   and h.ts < ?");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            ps.setTimestamp(2, since);
            ps.setTimestamp(3, since);
            ps.setTimestamp(4, to);
            ps.setTimestamp(5, to);
            ps.setString(6, nickname);
            ps.setString(7, nickname);
            ps.setTimestamp(8, id_ts);
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            conn.close();
        }
    }

    public static void tigMucMamGetMessages(String roomJid, Timestamp since, Timestamp to, String nickname, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select h.sender_nickname, h.stable_id, h.ts, h.sender_jid, h.body, h.msg from tig_muc_room_history h where h.room_jid_sha1 = ?\tand (? is null or h.ts >= ?)\tand (? is null or h.ts <= ?)\tand (? is null or h.sender_nickname = ?) order by h.ts asc offset ? rows fetch next ? rows only");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            ps.setTimestamp(2, since);
            ps.setTimestamp(3, since);
            ps.setTimestamp(4, to);
            ps.setTimestamp(5, to);
            ps.setString(6, nickname);
            ps.setString(7, nickname);
            ps.setInt(8, offset);
            ps.setInt(9, limit);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucMamGetMessagesCount(String roomJid, Timestamp since, Timestamp to, String nickname, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select count(1) from tig_muc_room_history h where h.room_jid_sha1 = ?\tand (? is null or h.ts >= ?)\tand (? is null or h.ts <= ?)\tand (? is null or h.sender_nickname = ?)");
            ps.setString(1, StoredProcedures.sha1OfLower(roomJid));
            ps.setTimestamp(2, since);
            ps.setTimestamp(3, since);
            ps.setTimestamp(4, to);
            ps.setTimestamp(5, to);
            ps.setString(6, nickname);
            ps.setString(7, nickname);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigMucMamUpdateMessage(String roomJid, String stableId, String body, String msg) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_muc_room_history set body = ?, msg = ? where room_jid_sha1 = ? and stable_id = ?");
            ps.setString(1, body);
            ps.setString(2, msg);
            ps.setString(3, StoredProcedures.sha1OfLower(roomJid));
            ps.setString(4, stableId);
            ps.executeUpdate();
        }
    }

    public static void tigMucSetAvatar(Long roomId, Clob avatar, String avatarHash) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_muc_rooms set avatar = ?, avatar_hash = ? where room_id = ?");
            ps.setClob(1, avatar);
            ps.setString(2, avatarHash);
            ps.setLong(3, roomId);
            ps.executeUpdate();
        }
    }

    public static void tigMucSetRoomAffiliation(Long roomId, String jid, String affiliation, Boolean persistent, String nickname) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String jidSha1 = StoredProcedures.sha1OfLower(jid);
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_muc_room_affiliations where room_id = ? and jid_sha1 = ?");
            ps.setLong(1, roomId);
            ps.setString(2, jidSha1);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                if (!"none".equals(affiliation)) {
                    ps = conn.prepareStatement("update tig_muc_room_affiliations set affiliation = ?, persistent = ?, nickname = ? where room_id = ? and jid_sha1 = ?");
                    ps.setString(1, affiliation);
                    ps.setBoolean(2, persistent);
                    ps.setString(3, nickname);
                    ps.setLong(4, roomId);
                    ps.setString(5, jidSha1);
                    ps.executeUpdate();
                } else {
                    ps = conn.prepareStatement("delete from tig_muc_room_affiliations where room_id = ? and jid_sha1 = ?");
                    ps.setLong(1, roomId);
                    ps.setString(2, jidSha1);
                    ps.executeUpdate();
                }
            } else if (!"none".equals(affiliation)) {
                ps = conn.prepareStatement("insert into tig_muc_room_affiliations (room_id, jid, jid_sha1, affiliation, persistent, nickname) values (?, ?, ?, ?, ?, ?)");
                ps.setLong(1, roomId);
                ps.setString(2, jid);
                ps.setString(3, jidSha1);
                ps.setString(4, affiliation);
                ps.setBoolean(5, persistent);
                ps.setString(6, nickname);
                ps.executeUpdate();
            }
        }
    }

    public static void tigMucSetRoomConfig(String roomJid, String name, String config) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_muc_rooms set name = ?, config = ? where jid_sha1 = ?");
            ps.setString(1, name);
            ps.setString(2, config);
            ps.setString(3, StoredProcedures.sha1OfLower(roomJid));
            ps.executeUpdate();
        }
    }

    public static void tigMucSetRoomSubject(Long roomId, String subject, String creator, Timestamp changeDate) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_muc_rooms set subject = ?, subject_creator_nick = ?, subject_date = ? where room_id = ?");
            ps.setString(1, subject);
            ps.setString(2, creator);
            ps.setTimestamp(3, changeDate);
            ps.setLong(4, roomId);
            ps.executeUpdate();
        }
    }
}

