/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Date;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.muc.MUCComponent;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.mam.MAM2QueryParser;
import tigase.xmpp.mam.Query;
import tigase.xmpp.rsm.RSM;

@Bean(name="mamQueryParser", parent=MUCComponent.class, active=true)
public class MAMQueryParser
extends MAM2QueryParser {
    public Query parseQuery(Query query, Packet packet) throws ComponentException {
        Query request = super.parseQuery(query, packet);
        this.handleOldIds(request);
        return request;
    }

    protected void validateRsm(RSM rsm) throws ComponentException {
    }

    protected void handleOldIds(Query request) throws ComponentException {
        if (request.getRsm().getBefore() != null && !this.maybeUUID(request.getRsm().getBefore())) {
            try {
                Date before = new Date(Long.parseLong(request.getRsm().getBefore()) - 1L);
                if (request.getEnd() == null || request.getEnd().after(before)) {
                    request.setEnd(before);
                }
                request.getRsm().setBefore(null);
                request.getRsm().setHasBefore(true);
            }
            catch (NumberFormatException ex) {
                throw new ComponentException(Authorization.NOT_ACCEPTABLE, "Invalid RSM before value");
            }
        }
        if (request.getRsm().getAfter() != null && !this.maybeUUID(request.getRsm().getAfter())) {
            try {
                Date after = new Date(Long.parseLong(request.getRsm().getAfter()) + 1L);
                if (request.getStart() == null || request.getStart().before(after)) {
                    request.setStart(after);
                }
                request.getRsm().setAfter(null);
            }
            catch (NumberFormatException ex) {
                throw new ComponentException(Authorization.NOT_ACCEPTABLE, "Invalid RSM after value");
            }
        }
    }

    private boolean maybeUUID(String name) {
        if (name.charAt(8) != '-') {
            return false;
        }
        if (name.charAt(13) != '-') {
            return false;
        }
        if (name.charAt(18) != '-') {
            return false;
        }
        return name.charAt(23) == '-';
    }
}

