/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.MUCConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="groupchat", active=true)
public class GroupchatMessageModule
extends AbstractMucModule {
    public static final String ID = "groupchat";
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"groupchat");
    private static final Criteria CRIT_CHAT_STAT = ElementCriteria.xmlns((String)"http://jabber.org/protocol/chatstates");
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();
    @Inject
    private MUCConfig config;
    @Inject
    private HistoryProvider historyProvider;
    @Inject(nullAllowed=true)
    private MucLogger mucLogger;
    @Inject
    private IMucRepository repository;
    private final TimestampHelper timestampHelper = new TimestampHelper();

    public static String generateSubjectId(Date ts, String subject) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(String.valueOf(ts.getTime() / 100L).getBytes());
            if (subject != null) {
                md.update(subject.getBytes());
            }
            StringBuilder sb = new StringBuilder();
            for (byte b : md.digest()) {
                sb.append(Character.forDigit((b & 0xF0) >> 4, 16));
                sb.append(Character.forDigit(b & 0xF, 16));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public GroupchatMessageModule() {
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"oob", (String)"jabber:x:oob"));
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"encrypted", (String)"eu.siacs.conversations.axolotl"));
    }

    public String[] getFeatures() {
        ArrayList<String> f = new ArrayList<String>();
        f.add("http://jabber.org/protocol/muc");
        f.add("http://jabber.org/protocol/muc#stable_id");
        if (this.isChatStateAllowed()) {
            f.add("http://jabber.org/protocol/chatstates");
        }
        return f.toArray(new String[0]);
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isChatStateAllowed() {
        return this.allowedElements.contains(CRIT_CHAT_STAT);
    }

    public void process(Packet packet) throws MUCException {
        try {
            String msg;
            Date sendDate;
            JID senderJID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
            if (GroupchatMessageModule.getNicknameFromJid(JID.jidInstance((String)packet.getAttributeStaticStr("to"))) != null) {
                throw new MUCException(Authorization.BAD_REQUEST, "Groupchat message can't be addressed to occupant.");
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "There is no such room.");
            }
            String nickName = room.getOccupantsNickname(senderJID);
            Role role = room.getRole(nickName);
            Affiliation affiliation = room.getAffiliation(senderJID.getBareJID()).getAffiliation();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Processing groupchat message. room=" + roomJID + "; senderJID=" + senderJID + "; senderNickname=" + nickName + "; role=" + role + "; affiliation=" + affiliation + ";");
            }
            if (!role.isSendMessagesToAll() || room.getConfig().isRoomModerated() && role == Role.visitor) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Insufficient privileges to send grouchat message: role=" + role + "; roomModerated=" + room.getConfig().isRoomModerated() + "; stanza=" + packet.getElement().toStringNoChildren());
                }
                throw new MUCException(Authorization.FORBIDDEN, "Insufficient privileges to send groupchat message.");
            }
            this.validateRTBL(senderJID.getBareJID(), affiliation);
            String xmlLang = packet.getElement().getAttributeStaticStr("xml:lang");
            Element body = null;
            Element subject = null;
            Element delay = null;
            String id = packet.getAttributeStaticStr("id");
            ArrayList<Element> content = new ArrayList<Element>();
            List ccs = packet.getElement().getChildren();
            if (ccs != null) {
                block6: for (Element c : ccs) {
                    if ("delay".equals(c.getName())) {
                        delay = c;
                        continue;
                    }
                    if ("body".equals(c.getName())) {
                        body = c;
                        content.add(c);
                        continue;
                    }
                    if ("subject".equals(c.getName())) {
                        subject = c;
                        content.add(c);
                        continue;
                    }
                    if (!this.config.isMessageFilterEnabled()) {
                        content.add(c);
                        continue;
                    }
                    if (this.config.isChatStateAllowed() && CRIT_CHAT_STAT.match(c)) {
                        content.add(c);
                        continue;
                    }
                    for (Criteria crit : this.allowedElements) {
                        if (!crit.match(c)) continue;
                        content.add(c);
                        continue block6;
                    }
                }
            }
            JID senderRoomJID = JID.jidInstance((BareJID)roomJID, (String)nickName);
            if (delay != null && affiliation == Affiliation.owner) {
                try {
                    sendDate = this.timestampHelper.parseTimestamp(delay.getAttributeStaticStr("stamp"));
                }
                catch (ParseException ex) {
                    throw new MUCException(Authorization.BAD_REQUEST, "Invalid format of attribute stamp");
                }
            } else {
                sendDate = new Date();
            }
            if (subject != null) {
                if (!(room.getConfig().isChangeSubject() && role == Role.participant || role.isModifySubject())) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Insufficient privileges to change subject: role=" + role + "; allowToChangeSubject=" + room.getConfig().isChangeSubject() + "; stanza=" + packet.getElement().toStringNoChildren());
                    }
                    throw new MUCException(Authorization.FORBIDDEN, "Insufficient privileges to change subject.");
                }
                msg = subject.getCData();
                room.setNewSubject(msg, nickName);
                room.setSubjectChangeDate(sendDate);
            }
            if (id == null && this.config.isAddMessageIdIfMissing()) {
                id = subject != null ? GroupchatMessageModule.generateSubjectId(sendDate, subject == null ? "" : subject.getCData()) : UUID.randomUUID().toString();
            }
            msg = this.preparePacket(id, xmlLang, content.toArray(new Element[0]));
            if (body != null) {
                String stableId = UUID.randomUUID().toString();
                this.addMessageToHistory(room, msg.getElement(), body.getCData(), senderJID, nickName, sendDate, stableId);
                msg.getElement().addChild((XMLNodeIfc)new Element("stanza-id", new String[]{"xmlns", "id", "by"}, new String[]{"urn:xmpp:sid:0", stableId, roomJID.toString()}));
            }
            if (subject != null) {
                this.addSubjectChangeToHistory(room, msg.getElement(), subject.getCData(), senderJID, nickName, sendDate);
            }
            this.sendMessagesToAllOccupants(room, senderRoomJID, (Packet)msg);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error during processing groupchat message", e);
            throw new RuntimeException(e);
        }
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, Element ... content) throws TigaseStringprepException {
        Packet msg = this.preparePacket(null, null, content);
        this.sendMessagesToAllOccupants(room, fromJID, msg);
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, String xmlLang, Element ... content) throws TigaseStringprepException {
        Packet msg = this.preparePacket(null, xmlLang, content);
        this.sendMessagesToAllOccupants(room, fromJID, msg);
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, Packet msg) throws TigaseStringprepException {
        this.sendMessagesToAllOccupantsJids(room, fromJID, msg);
        room.fireOnMessageToOccupants(fromJID, msg);
    }

    public void sendMessagesToAllOccupantsJids(Room room, JID fromJID, Packet msg) throws TigaseStringprepException {
        room.getAllJidsForMessageDelivery().forEach(jid -> {
            Packet message = msg.copyElementOnly();
            message.initVars(fromJID, jid);
            message.setXMLNS("jabber:client");
            this.write(message);
        });
    }

    protected void addMessageToHistory(Room room, Element message, String body, JID senderJid, String senderNickname, Date time, String stableId) {
        block7: {
            block6: {
                try {
                    if (this.historyProvider != null) {
                        this.historyProvider.addMessage(room, message, body, senderJid, senderNickname, time, stableId);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.WARNING)) break block6;
                    this.log.log(Level.WARNING, "Can't add message to history!", e);
                }
            }
            try {
                if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
                    this.mucLogger.addMessage(room, body, senderJid, senderNickname, time);
                }
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.WARNING)) break block7;
                this.log.log(Level.WARNING, "Can't add message to log!", e);
            }
        }
    }

    protected void addSubjectChangeToHistory(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
        block7: {
            block6: {
                try {
                    if (this.historyProvider != null) {
                        this.historyProvider.addSubjectChange(room, message, subject, senderJid, senderNickname, time);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.WARNING)) break block6;
                    this.log.log(Level.WARNING, "Can't add subject change to history!", e);
                }
            }
            try {
                if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
                    this.mucLogger.addSubjectChange(room, subject, senderJid, senderNickname, time);
                }
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.WARNING)) break block7;
                this.log.log(Level.WARNING, "Can't add subject change to log!", e);
            }
        }
    }

    protected Packet preparePacket(String messageId, String xmlLang, Element ... content) throws TigaseStringprepException {
        Element e = new Element("message", new String[]{"type"}, new String[]{ID});
        if (messageId != null) {
            e.setAttribute("id", messageId);
        }
        if (xmlLang != null) {
            e.setAttribute("xml:lang", xmlLang);
        }
        if (content != null) {
            e.addChildren(Arrays.asList(content));
        }
        Packet message = Packet.packetInstance((Element)e);
        message.setXMLNS("jabber:client");
        return message;
    }
}

