/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collection;
import java.util.logging.Level;
import tigase.component.modules.AbstractModule;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.rtbl.RTBLRepository;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class AbstractMucModule
extends AbstractModule {
    @Inject(nullAllowed=true)
    private RTBLRepository rtblRepository;

    public static Element createResultIQ(Element iq) {
        return new Element("iq", new String[]{"type", "from", "to", "id"}, new String[]{"result", iq.getAttributeStaticStr("to"), iq.getAttributeStaticStr("from"), iq.getAttributeStaticStr("id")});
    }

    public static String getNicknameFromJid(JID jid) {
        if (jid != null) {
            return jid.getResource();
        }
        return null;
    }

    protected void sendMucMessage(Room room, String recipientNickame, String message) throws TigaseStringprepException {
        Collection<JID> occupantJids = room.getOccupantsJidsByNickname(recipientNickame);
        for (JID jid : occupantJids) {
            Packet msg = Message.getMessage((JID)JID.jidInstance((BareJID)room.getRoomJID()), (JID)jid, (StanzaType)StanzaType.groupchat, (String)message, null, null, null);
            msg.setXMLNS("jabber:client");
            this.writer.write(msg);
        }
    }

    protected void validateRTBL(BareJID senderJID, Affiliation affiliation) throws MUCException {
        if (affiliation == Affiliation.none) {
            if (this.rtblRepository != null) {
                if (this.rtblRepository.isBlocked(senderJID)) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("User " + senderJID + " matches entry in RTBL");
                    }
                    throw new MUCException(Authorization.FORBIDDEN, "You are banned from this service");
                }
            } else {
                this.log.finest("skipping RTBL check, no RTBL repository available");
            }
        }
    }
}

