/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.muc.MUCComponent;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.logger.MucLogger;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="muc-logger", parent=MUCComponent.class, active=false)
public class RoomChatLogger
implements MucLogger,
Initializable {
    private static final Logger log = Logger.getLogger(RoomChatLogger.class.getName());
    private static final String JOIN_HTML_FORMAT = "<a name=\"%1$s\" href=\"#%1$s\" class=\"mj\">[%1$s]</a>%2$s joins the room<br/>\n";
    private static final String JOIN_PLAIN_FORMAT = "[%1$s] %2$s joins the room\n";
    private static final String LEAVE_HTML_FORMAT = "<a name=\"%1$s\" href=\"#%1$s\" class=\"ml\">[%1$s]</a>%2$s leaves the room<br/>\n";
    private static final String LEAVE_PLAIN_FORMAT = "[%1$s] %2$s leaves the room\n";
    private static final String MESSAGE_HTML_FORMAT = "<a name=\"%1$s\" href=\"%1$s\" class=\"ts\">[%1$s]</a> <font class=\"mn\">&lt;%2$s&gt;</font>%3$s<br/>\n";
    private static final String MESSAGE_PLAIN_FORMAT = "[%1$s] <%2$s> %3$s\n";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
    private static final String SUBJECT_HTML_FORMAT = "<a name=\"%1$s\" href=\"#%1$s\" class=\"msc\">[%1$s]</a>%2$s has set the subject to: %3$s<br/>\n";
    private static final String SUBJECT_PLAIN_FORMAT = "[%1$s] %2$s has set the subject to: %3$s\n";
    private final Worker worker = new Worker();
    @Inject
    private MUCConfig config;

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
        this.addLine(switch (room.getConfig().getLoggingFormat()) {
            case RoomConfig.LogFormat.html -> JOIN_HTML_FORMAT;
            case RoomConfig.LogFormat.xml -> JOIN_PLAIN_FORMAT;
            case RoomConfig.LogFormat.plain -> JOIN_PLAIN_FORMAT;
            default -> throw new RuntimeException("Unsupported log format: " + room.getConfig().getLoggingFormat());
        }, room.getConfig().getLoggingFormat(), room.getRoomJID(), date, nickName, null);
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
        this.addLine(switch (room.getConfig().getLoggingFormat()) {
            case RoomConfig.LogFormat.html -> LEAVE_HTML_FORMAT;
            case RoomConfig.LogFormat.xml -> LEAVE_PLAIN_FORMAT;
            case RoomConfig.LogFormat.plain -> LEAVE_PLAIN_FORMAT;
            default -> throw new RuntimeException("Unsupported log format: " + room.getConfig().getLoggingFormat());
        }, room.getConfig().getLoggingFormat(), room.getRoomJID(), date, nickName, null);
    }

    @Override
    public void addMessage(Room room, String message, JID senderJid, String senderNickname, Date time) {
        this.addLine(switch (room.getConfig().getLoggingFormat()) {
            case RoomConfig.LogFormat.html -> MESSAGE_HTML_FORMAT;
            case RoomConfig.LogFormat.xml -> MESSAGE_PLAIN_FORMAT;
            case RoomConfig.LogFormat.plain -> MESSAGE_PLAIN_FORMAT;
            default -> throw new RuntimeException("Unsupported log format: " + room.getConfig().getLoggingFormat());
        }, room.getConfig().getLoggingFormat(), room.getRoomJID(), time, senderNickname, message);
    }

    @Override
    public void addSubjectChange(Room room, String message, JID senderJid, String senderNickname, Date time) {
        this.addLine(switch (room.getConfig().getLoggingFormat()) {
            case RoomConfig.LogFormat.html -> SUBJECT_HTML_FORMAT;
            case RoomConfig.LogFormat.xml -> SUBJECT_PLAIN_FORMAT;
            case RoomConfig.LogFormat.plain -> SUBJECT_PLAIN_FORMAT;
            default -> throw new RuntimeException("Unsupported log format: " + room.getConfig().getLoggingFormat());
        }, room.getConfig().getLoggingFormat(), room.getRoomJID(), time, senderNickname, message);
    }

    public void initialize() {
        this.worker.start();
    }

    private void addLine(String pattern, RoomConfig.LogFormat logFormat, BareJID roomJID, Date date, String nickName, String text) {
        String d = sdf.format(date);
        Object[] values = new String[]{d, nickName, text};
        String line = String.format(pattern, values);
        Item it = new Item(new File(this.config.getChatLoggingDirectory() + "/" + roomJID + (switch (logFormat) {
            case RoomConfig.LogFormat.html -> ".html";
            case RoomConfig.LogFormat.xml -> ".xml";
            case RoomConfig.LogFormat.plain -> ".txt";
            default -> throw new RuntimeException("Unsupported log format: " + logFormat.name());
        })), line);
        this.worker.items.add(it);
    }

    private static class Worker
    extends Thread {
        private final LinkedList<Item> items = new LinkedList();

        private Worker() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Item it;
                    if ((it = this.items.poll()) == null) {
                        Worker.sleep(1000L);
                        continue;
                    }
                    FileWriter fw = new FileWriter(it.file, true);
                    fw.append(it.data);
                    fw.close();
                    Worker.sleep(15L);
                }
            }
            catch (IOException | InterruptedException e) {
                log.log(Level.WARNING, "Storing message failed", e);
                return;
            }
        }
    }

    private static class Item {
        final String data;
        final File file;

        public Item(File file, String text) {
            this.file = file;
            this.data = text;
        }
    }
}

