/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.core.Kernel;
import tigase.muc.AbstractMucTest;
import tigase.muc.PermissionChecker;
import tigase.muc.Room;
import tigase.muc.TestMUCCompoent;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PresenceModuleImpl;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.DummyVHostManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PresenceModuleImplTest
extends AbstractMucTest {
    private PermissionChecker permissionChecker;
    private final String vhost = "tigase.org";
    private final String componentName = "muc";
    private final String mucDomain = "muc.tigase.org";
    private final JID regularUserJid = JID.jidInstanceNS((String)"wojtek", (String)"tigase.org", (String)"test");
    private final JID domainAdminJID = JID.jidInstanceNS((String)"domain_admin", (String)"tigase.org", (String)"resource");
    private final JID adminJID = JID.jidInstanceNS((String)"admin", (String)"tigase.org", (String)"resource");
    final BareJID roomJID = BareJID.bareJIDInstanceNS((String)"room", (String)"muc.tigase.org");
    private PresenceModule presenceModule;
    private TestMUCCompoent mucComponent;
    private static final String[] bodyPath = new String[]{"message", "body"};

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(PresenceModuleImpl.class).exec();
        this.mucComponent = (TestMUCCompoent)((Object)this.getKernel().getInstance(TestMUCCompoent.class));
        this.mucComponent.setAdmins(Set.of(this.adminJID.getBareJID()));
        DummyVHostManager vHostManager = (DummyVHostManager)this.getKernel().getInstance(DummyVHostManager.class);
        vHostManager.addVhost("tigase.org");
        vHostManager.getVHostItem("tigase.org").setAdmins(new String[]{this.domainAdminJID.getBareJID().toString()});
        this.permissionChecker = (PermissionChecker)this.getMucKernel().getInstance(PermissionChecker.class);
        this.presenceModule = (PresenceModule)this.getMucKernel().getInstance(PresenceModule.class);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDefaultPermissionsRegularUser() throws RepositoryException, ComponentException, TigaseStringprepException {
        Element presence = new Element("presence");
        presence.setAttribute("to", this.roomJID + "/thirdwitch");
        presence.setAttribute("from", this.regularUserJid.toString());
        presence.addChild((XMLNodeIfc)new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc"}));
        Packet packet = Packet.packetInstance((Element)presence);
        this.presenceModule.process(packet);
        boolean new_hidden_room = this.writer.getElements().stream().map(message -> Optional.ofNullable(message.getCData(bodyPath))).flatMap(Optional::stream).anyMatch(body -> body.contains("You've created new hidden room"));
        Assert.assertTrue((String)"Missing message about hidden room creation", (boolean)new_hidden_room);
        Map publicVisibleRooms = this.mucComponent.getMucRepository().getPublicVisibleRooms("muc.tigase.org");
        Assert.assertEquals(Set.of(), publicVisibleRooms.keySet());
        Room room = this.mucComponent.getMucRepository().getRoom(this.roomJID);
        Assert.assertNotNull((Object)room);
        Assert.assertNotNull((Object)room.getConfig());
        Assert.assertFalse((boolean)room.getConfig().isRoomconfigPublicroom());
    }

    @Test
    public void testDefaultPermissionsDomainAdmin() throws RepositoryException, ComponentException, TigaseStringprepException {
        Element presence = new Element("presence");
        presence.setAttribute("to", this.roomJID + "/thirdwitch");
        presence.setAttribute("from", this.domainAdminJID.toString());
        presence.addChild((XMLNodeIfc)new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc"}));
        Packet packet = Packet.packetInstance((Element)presence);
        this.presenceModule.process(packet);
        boolean new_hidden_room = this.writer.getElements().stream().map(message -> Optional.ofNullable(message.getCData(bodyPath))).flatMap(Optional::stream).anyMatch(body -> body.contains("You've created new public room"));
        Assert.assertTrue((String)"Missing message about public room creation", (boolean)new_hidden_room);
        Map publicVisibleRooms = this.mucComponent.getMucRepository().getPublicVisibleRooms("muc.tigase.org");
        Assert.assertEquals(Set.of(this.roomJID), publicVisibleRooms.keySet());
        Room room = this.mucComponent.getMucRepository().getRoom(this.roomJID);
        Assert.assertNotNull((Object)room);
        Assert.assertNotNull((Object)room.getConfig());
        Assert.assertTrue((boolean)room.getConfig().isRoomconfigPublicroom());
    }

    @Test
    public void testDefaultPermissionsSystemAdmin() throws RepositoryException, ComponentException, TigaseStringprepException {
        Element presence = new Element("presence");
        presence.setAttribute("to", this.roomJID + "/thirdwitch");
        presence.setAttribute("from", this.adminJID.toString());
        presence.addChild((XMLNodeIfc)new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc"}));
        Packet packet = Packet.packetInstance((Element)presence);
        this.presenceModule.process(packet);
        boolean new_hidden_room = this.writer.getElements().stream().map(message -> Optional.ofNullable(message.getCData(bodyPath))).flatMap(Optional::stream).anyMatch(body -> body.contains("You've created new public room"));
        Assert.assertTrue((String)"Missing message about public room creation", (boolean)new_hidden_room);
        Map publicVisibleRooms = this.mucComponent.getMucRepository().getPublicVisibleRooms("muc.tigase.org");
        Assert.assertEquals(Set.of(this.roomJID), publicVisibleRooms.keySet());
        Room room = this.mucComponent.getMucRepository().getRoom(this.roomJID);
        Assert.assertNotNull((Object)room);
        Assert.assertNotNull((Object)room.getConfig());
        Assert.assertTrue((boolean)room.getConfig().isRoomconfigPublicroom());
    }
}

