/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.DSLBeanConfigurator;
import tigase.conf.ConfigWriter;
import tigase.kernel.core.Kernel;
import tigase.muc.AbstractMucTest;
import tigase.muc.Affiliation;
import tigase.muc.MUCComponent;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class ModeratorModuleTest
extends AbstractMucTest {
    private final ModeratorModule m = new ModeratorModule();
    private JID admin;
    private JID member;
    private ModeratorModule moderatorModule;
    private MUCComponent mucComponent;
    private Room room;

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        Map<String, Object> props = new HashMap<String, Object>();
        props.put("muc/multi-user-chat", BareJID.bareJIDInstanceNS((String)"multi-user-chat"));
        props.put("muc/message-filter-enabled", Boolean.TRUE);
        props.put("muc/presence-filter-enabled", Boolean.FALSE);
        props.put("muc/room-log-directory", "./");
        props = ConfigWriter.buildTree(props);
        ((DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class)).setProperties(props);
        this.admin = JID.jidInstanceNS((String)"admin@example.com/res1");
        this.member = JID.jidInstanceNS((String)"member@example.com/res1");
        try {
            this.room = ((IMucRepository)this.getMucKernel().getInstance(IMucRepository.class)).createNewRoom(BareJID.bareJIDInstanceNS((String)"darkcave@macbeth.shakespeare.lit"), this.admin);
            this.room.addAffiliationByJid(this.admin.getBareJID(), RoomAffiliation.admin);
            this.room.addAffiliationByJid(this.member.getBareJID(), RoomAffiliation.member);
            this.moderatorModule = new ModeratorModule();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testCheckItem() throws Exception {
        Element item = new Element("item", new String[]{"jid"}, new String[]{"occupand@b.c"});
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.admin, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.owner);
        }
        catch (MUCException e) {
            Assert.fail((String)("Invalid result: " + e.getMessage()));
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.member, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.admin);
        }
        catch (MUCException e) {
            Assert.fail((String)("Invalid result: " + e.getMessage()));
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.admin, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.admin);
            Assert.fail();
        }
        catch (MUCException e) {
            Assert.assertEquals((Object)Authorization.NOT_ALLOWED, (Object)e.getErrorCondition());
            System.out.println("OK: " + e.getMessage());
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.admin, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.none);
            Assert.fail();
        }
        catch (MUCException e) {
            Assert.assertEquals((Object)Authorization.NOT_ALLOWED, (Object)e.getErrorCondition());
            System.out.println("OK: " + e.getMessage());
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, Role.moderator, null, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.none);
            Assert.fail();
        }
        catch (MUCException e) {
            Assert.assertEquals((Object)Authorization.NOT_ALLOWED, (Object)e.getErrorCondition());
            System.out.println("OK: " + e.getMessage());
        }
    }

    @Test(expected=MUCException.class)
    public void checkEmptyItem() throws Exception {
        Element item = new Element("item");
        this.moderatorModule.checkItem(this.room, item, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleWithoutNick() throws Exception {
        Element item1 = new Element("item", new String[]{"jid", "role"}, new String[]{"member@example.com", Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleWithoutNickAndWithAffiliation() throws Exception {
        Element item1 = new Element("item", new String[]{"role", "affiliation"}, new String[]{Role.none.toString(), Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleOnly() throws Exception {
        Element item1 = new Element("item", new String[]{"role"}, new String[]{Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyOwnerItemAffiliationWithoutJid() throws Exception {
        Element item1 = new Element("item", new String[]{"nick", "affiliation"}, new String[]{"member_user", Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyOwnerItemAffiliationOnly() throws Exception {
        Element item1 = new Element("item", new String[]{"affiliation"}, new String[]{Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test
    public void checkModifyVoiceItem() throws Exception {
        Element item1 = new Element("item", new String[]{"nick", "role"}, new String[]{"member_user", Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test
    public void checkModifyOwnerItem() throws Exception {
        Element item1 = new Element("item", new String[]{"jid", "affiliation"}, new String[]{"member@example.com", Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }
}

