/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.exceptions.ComponentException;
import tigase.muc.modules.MAMQueryParser;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.QueryImpl;

public class MAMQueryParserTest {
    private final MAMQueryParser mamQueryParser = new MAMQueryParser();

    @Test
    public void testHandlingOldMessageIds_After() throws ComponentException {
        QueryImpl query = new QueryImpl();
        Date after = new Date();
        query.getRsm().setAfter(String.valueOf(after.getTime()));
        this.mamQueryParser.handleOldIds((Query)query);
        Assert.assertNull((Object)query.getRsm().getAfter());
        Assert.assertEquals((long)(after.getTime() + 1L), (long)query.getStart().getTime());
    }

    @Test
    public void testHandlingOldMessageIds_AfterAndStart() throws ComponentException {
        QueryImpl query = new QueryImpl();
        Date after = new Date();
        Date start = new Date(after.getTime() - 10000L);
        query.setStart(start);
        query.getRsm().setAfter(String.valueOf(after.getTime()));
        this.mamQueryParser.handleOldIds((Query)query);
        Assert.assertNull((Object)query.getRsm().getAfter());
        Assert.assertEquals((long)(after.getTime() + 1L), (long)query.getStart().getTime());
    }

    @Test
    public void testHandlingOldMessageIds_AfterAndStart2() throws ComponentException {
        QueryImpl query = new QueryImpl();
        Date after = new Date();
        Date start = new Date(after.getTime() + 10000L);
        query.setStart(start);
        query.getRsm().setAfter(String.valueOf(after.getTime()));
        this.mamQueryParser.handleOldIds((Query)query);
        Assert.assertNull((Object)query.getRsm().getAfter());
        Assert.assertEquals((long)start.getTime(), (long)query.getStart().getTime());
    }

    @Test
    public void testHandlingOldMessageIds_Before() throws ComponentException {
        QueryImpl query = new QueryImpl();
        Date before = new Date();
        query.getRsm().setBefore(String.valueOf(before.getTime()));
        this.mamQueryParser.handleOldIds((Query)query);
        Assert.assertNull((Object)query.getRsm().getBefore());
        Assert.assertEquals((long)(before.getTime() - 1L), (long)query.getEnd().getTime());
    }

    @Test
    public void testHandlingOldMessageIds_BeforeAndEnd() throws ComponentException {
        QueryImpl query = new QueryImpl();
        Date before = new Date();
        Date end = new Date(before.getTime() + 10000L);
        query.setEnd(end);
        query.getRsm().setBefore(String.valueOf(before.getTime()));
        this.mamQueryParser.handleOldIds((Query)query);
        Assert.assertNull((Object)query.getRsm().getBefore());
        Assert.assertEquals((long)(before.getTime() - 1L), (long)query.getEnd().getTime());
    }

    @Test
    public void testHandlingOldMessageIds_BeforeAndEnd2() throws ComponentException {
        QueryImpl query = new QueryImpl();
        Date before = new Date();
        Date end = new Date(before.getTime() - 10000L);
        query.setEnd(end);
        query.getRsm().setBefore(String.valueOf(before.getTime()));
        this.mamQueryParser.handleOldIds((Query)query);
        Assert.assertNull((Object)query.getRsm().getBefore());
        Assert.assertEquals((long)end.getTime(), (long)query.getEnd().getTime());
    }
}

