/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.db.TigaseDBException;
import tigase.kernel.core.Kernel;
import tigase.muc.AbstractMucTest;
import tigase.muc.Affiliation;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.server.Packet;
import tigase.server.rtbl.RTBLRepository;
import tigase.util.Algorithms;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

public class AbstractMucModuleTest
extends AbstractMucTest {
    private static final BareJID RTBL_JID = BareJID.bareJIDInstanceNS((String)"test@rtbl-test.tigase");
    private static final String RTBL_NODE = "muc_ban";
    private MUCModuleTest module;
    private RTBLRepository rtblRepository;

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(RTBLRepository.class).exec();
        this.getMucKernel().registerBean("mucModuleTest").asClass(MUCModuleTest.class).exec();
        this.rtblRepository = (RTBLRepository)kernel.getInstance(RTBLRepository.class);
        try {
            this.rtblRepository.add(RTBL_JID, RTBL_NODE, "SHA-256");
        }
        catch (TigaseDBException ex) {
            throw new RuntimeException(ex);
        }
        this.module = (MUCModuleTest)((Object)this.getMucKernel().getInstance(MUCModuleTest.class));
    }

    @Test
    public void testEmptyList() throws MUCException {
        BareJID userJid = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"test.tigase");
        this.module.validateRTBL(userJid, Affiliation.none);
    }

    @Test
    public void testBlockedJid() throws MUCException, InterruptedException {
        BareJID userJid = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"test.tigase");
        this.rtblRepository.update(RTBL_JID, RTBL_NODE, RTBLRepository.Action.add, AbstractMucModuleTest.sha256(userJid.toString()));
        Thread.sleep(10L);
        Assert.assertThrows(MUCException.class, () -> this.module.validateRTBL(userJid, Affiliation.none));
        this.rtblRepository.update(RTBL_JID, RTBL_NODE, RTBLRepository.Action.remove, AbstractMucModuleTest.sha256(userJid.toString()));
        Thread.sleep(10L);
        this.module.validateRTBL(userJid, Affiliation.none);
    }

    @Test
    public void testBlockedDomain() throws MUCException, InterruptedException {
        BareJID userJid = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"test.tigase");
        this.rtblRepository.update(RTBL_JID, RTBL_NODE, RTBLRepository.Action.add, AbstractMucModuleTest.sha256(userJid.getDomain()));
        Thread.sleep(10L);
        Assert.assertThrows(MUCException.class, () -> this.module.validateRTBL(userJid, Affiliation.none));
        this.rtblRepository.update(RTBL_JID, RTBL_NODE, RTBLRepository.Action.remove, AbstractMucModuleTest.sha256(userJid.getDomain()));
        Thread.sleep(10L);
        this.module.validateRTBL(userJid, Affiliation.none);
    }

    private static String sha256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return Algorithms.bytesToHex((byte[])md.digest(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MUCModuleTest
    extends AbstractMucModule {
        public Criteria getModuleCriteria() {
            return null;
        }

        public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        }
    }
}

