/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.responses.AsyncCallback;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.kernel.core.Kernel;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.RoomConfig;
import tigase.muc.history.ExtendedMAMRepository;
import tigase.muc.history.HistoryProvider;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractHistoryProviderTest<DS extends DataSource>
extends AbstractDataSourceAwareTestCase<DS, HistoryProvider> {
    protected static Date creationDate = null;
    protected static JID creatorJID = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"test.local", (String)UUID.randomUUID().toString());
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    protected static Room room;
    protected static BareJID roomJID;
    protected static List<Item> savedMessages;
    protected static String uri;
    protected boolean checkEmoji = true;
    protected HistoryProvider historyProvider;
    protected Room.RoomFactory roomFactory;

    @Before
    public void setup() throws RepositoryException, DBInitException, IllegalAccessException, InstantiationException {
        this.roomFactory = (Room.RoomFactory)this.getInstance(Room.RoomFactory.class);
        this.historyProvider = (HistoryProvider)this.getInstance(HistoryProvider.class);
    }

    @After
    public void tearDown() {
        this.historyProvider = null;
    }

    @Test
    public void test1_createRoom() throws RepositoryException {
        RoomConfig rc = new RoomConfig(roomJID);
        rc.setValue("muc#roomconfig_persistentroom", (Object)Boolean.TRUE);
        creationDate = new Date();
        room = this.roomFactory.newInstance(null, rc, creationDate, creatorJID.getBareJID());
        room.addAffiliationByJid(creatorJID.getBareJID(), RoomAffiliation.owner);
    }

    @Test
    public void test2_appendMessages() throws RepositoryException, InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Item item = new Item(this.checkEmoji ? emoji : "");
            this.historyProvider.addMessage(room, item.getMessage(room.getRoomJID()), item.body, item.sender, item.nick, item.ts, item.stableId);
            savedMessages.add(item);
            Thread.sleep(1000L);
        }
        QueueWriter writer = new QueueWriter();
        this.historyProvider.getHistoryMessages(room, creatorJID, null, Integer.valueOf(10), null, null, (PacketWriter)writer);
        Assert.assertEquals((long)10L, (long)writer.queue.size());
        for (int i = 0; i < savedMessages.size(); ++i) {
            Item item = savedMessages.get(i);
            Packet msg = writer.queue.poll();
            Assert.assertNotNull((Object)msg);
            String body = msg.getElemCDataStaticStr(new String[]{"message", "body"});
            Assert.assertEquals((Object)item.body, (Object)body);
            Assert.assertEquals((Object)msg.getStanzaFrom().getResource(), (Object)item.nick);
        }
    }

    @Test
    public void test3_getMessagesSince() throws RepositoryException, InterruptedException {
        Date since = AbstractHistoryProviderTest.savedMessages.get((int)4).ts;
        QueueWriter writer = new QueueWriter();
        this.historyProvider.getHistoryMessages(room, creatorJID, null, Integer.valueOf(10), null, since, (PacketWriter)writer);
        Assert.assertEquals((long)6L, (long)writer.queue.size());
        for (int i = 4; i < savedMessages.size(); ++i) {
            Item item = savedMessages.get(i);
            Packet msg = writer.queue.poll();
            Assert.assertNotNull((Object)msg);
            String body = msg.getElemCDataStaticStr(new String[]{"message", "body"});
            Assert.assertEquals((Object)item.body, (Object)body);
            Assert.assertEquals((Object)msg.getStanzaFrom().getResource(), (Object)item.nick);
        }
    }

    @Test
    public void test4_getMessagesMaxStanzas() throws RepositoryException, InterruptedException {
        QueueWriter writer = new QueueWriter();
        this.historyProvider.getHistoryMessages(room, creatorJID, null, Integer.valueOf(5), null, null, (PacketWriter)writer);
        Assert.assertEquals((long)5L, (long)writer.queue.size());
        for (int i = 5; i < savedMessages.size(); ++i) {
            Item item = savedMessages.get(i);
            Packet msg = writer.queue.poll();
            Assert.assertNotNull((Object)msg);
            String body = msg.getElemCDataStaticStr(new String[]{"message", "body"});
            Assert.assertEquals((Object)item.body, (Object)body);
            Assert.assertEquals((Object)msg.getStanzaFrom().getResource(), (Object)item.nick);
        }
    }

    @Test
    public void test4_mam_retrieveAll() throws RepositoryException, ComponentException, TigaseDBException {
        if (this.historyProvider instanceof MAMRepository) {
            MAMRepository mamRepository = (MAMRepository)this.historyProvider;
            Query query = mamRepository.newQuery();
            query.setComponentJID(JID.jidInstance((BareJID)roomJID));
            query.setQuestionerJID(creatorJID);
            ArrayList items = new ArrayList();
            mamRepository.queryItems(query, (query1, item) -> items.add(item));
            Assert.assertEquals((long)savedMessages.size(), (long)items.size());
            Assert.assertEquals((long)savedMessages.size(), (long)query.getRsm().getCount().intValue());
            IntStream.range(0, savedMessages.size() - 1).forEach(pos -> Assert.assertEquals((Object)AbstractHistoryProviderTest.savedMessages.get((int)pos).body, (Object)((MAMRepository.Item)items.get(pos)).getMessage().getChildCData(new String[]{"message", "body"})));
        }
    }

    @Test
    public void test4_mam_retrieveByStanzaId() throws RepositoryException {
        if (this.historyProvider instanceof MAMRepository) {
            ExtendedMAMRepository mamRepository = (ExtendedMAMRepository)this.historyProvider;
            int position = new Random().nextInt(savedMessages.size());
            Item savedItem = savedMessages.get(position);
            ExtendedMAMRepository.Item foundItem = mamRepository.getItem(roomJID, savedItem.stableId);
            Assert.assertEquals((Object)savedItem.stableId, (Object)foundItem.getId());
            Assert.assertEquals((Object)savedItem.body, (Object)foundItem.getMessage().getChildCData(new String[]{"message", "body"}));
        }
    }

    @Test
    public void test4_mam_retrieveBetween() throws RepositoryException, ComponentException, TigaseDBException {
        if (this.historyProvider instanceof MAMRepository) {
            Date since = AbstractHistoryProviderTest.savedMessages.get((int)4).ts;
            Date until = AbstractHistoryProviderTest.savedMessages.get((int)8).ts;
            MAMRepository mamRepository = (MAMRepository)this.historyProvider;
            Query query = mamRepository.newQuery();
            query.setComponentJID(JID.jidInstance((BareJID)roomJID));
            query.setQuestionerJID(creatorJID);
            query.setStart(since);
            query.setEnd(until);
            query.getRsm().setMax(2);
            ArrayList items = new ArrayList();
            mamRepository.queryItems(query, (query1, item) -> items.add(item));
            Assert.assertEquals((long)2L, (long)items.size());
            Assert.assertEquals((long)5L, (long)query.getRsm().getCount().intValue());
            Arrays.asList(0, 1).stream().forEach(pos -> Assert.assertEquals((Object)AbstractHistoryProviderTest.savedMessages.get((int)(4 + pos.intValue())).body, (Object)((MAMRepository.Item)items.get((int)pos)).getMessage().getChildCData(new String[]{"message", "body"})));
        }
    }

    @Test
    public void test4_mam_retrieveAfter() throws RepositoryException, ComponentException, TigaseDBException {
        if (this.historyProvider instanceof MAMRepository) {
            Date since = AbstractHistoryProviderTest.savedMessages.get((int)4).ts;
            Date until = AbstractHistoryProviderTest.savedMessages.get((int)8).ts;
            MAMRepository mamRepository = (MAMRepository)this.historyProvider;
            Query query = mamRepository.newQuery();
            query.setComponentJID(JID.jidInstance((BareJID)roomJID));
            query.setQuestionerJID(creatorJID);
            query.setStart(since);
            query.setEnd(until);
            query.getRsm().setMax(2);
            ArrayList items = new ArrayList();
            mamRepository.queryItems(query, (query1, item) -> items.add(item));
            Assert.assertEquals((long)2L, (long)items.size());
            Assert.assertEquals((long)5L, (long)query.getRsm().getCount().intValue());
            Assert.assertEquals((long)0L, (long)query.getRsm().getIndex().intValue());
            Arrays.asList(0, 1).stream().forEach(pos -> Assert.assertEquals((Object)AbstractHistoryProviderTest.savedMessages.get((int)(4 + pos.intValue())).body, (Object)((MAMRepository.Item)items.get((int)pos)).getMessage().getChildCData(new String[]{"message", "body"})));
            String id = ((MAMRepository.Item)items.get(0)).getId();
            String expId = ((MAMRepository.Item)items.get(1)).getId();
            items.clear();
            query.getRsm().setAfter(id);
            mamRepository.queryItems(query, (query1, item) -> items.add(item));
            Assert.assertEquals((long)2L, (long)items.size());
            Assert.assertEquals((long)5L, (long)query.getRsm().getCount().intValue());
            Assert.assertEquals((long)1L, (long)query.getRsm().getIndex().intValue());
            Assert.assertEquals((Object)expId, (Object)((MAMRepository.Item)items.get(0)).getId());
        }
    }

    @Test
    public void test5_mam_updateMessage() throws RepositoryException {
        if (this.historyProvider instanceof MAMRepository) {
            ExtendedMAMRepository mamRepository = (ExtendedMAMRepository)this.historyProvider;
            int position = new Random().nextInt(savedMessages.size());
            Item savedItem = savedMessages.get(position);
            String updatedBody = "Updated body " + UUID.randomUUID().toString();
            Element updatedMessage = new Element("message").withElement("body", body -> body.setCData(updatedBody));
            mamRepository.updateMessage(roomJID, savedItem.stableId, updatedMessage, updatedBody);
            ExtendedMAMRepository.Item foundItem = mamRepository.getItem(roomJID, savedItem.stableId);
            Assert.assertEquals((Object)savedItem.stableId, (Object)foundItem.getId());
            Assert.assertEquals((Object)updatedBody, (Object)foundItem.getMessage().getChildCData(new String[]{"message", "body"}));
        }
    }

    @Test
    public void test6_deleteMessages() throws RepositoryException {
        this.historyProvider.removeHistory(room);
        QueueWriter writer = new QueueWriter();
        this.historyProvider.getHistoryMessages(room, creatorJID, Integer.valueOf(0), Integer.valueOf(10), null, null, (PacketWriter)writer);
        Assert.assertEquals((long)0L, (long)writer.queue.size());
    }

    @Test
    public void test7_destroyRoom() {
        room = null;
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return HistoryProvider.class;
    }

    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(Room.RoomFactoryImpl.class).exec();
    }

    static {
        roomJID = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"muc.test.local");
        savedMessages = new ArrayList<Item>();
        uri = System.getProperty("testDbUri");
    }

    public static class Item {
        public final String body;
        public final String nick = UUID.randomUUID().toString();
        public final JID sender = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"test.local", (String)UUID.randomUUID().toString());
        public final Date ts = new Date();
        public final String stableId = UUID.randomUUID().toString();

        public Item(String suffix) {
            this.body = UUID.randomUUID().toString() + suffix;
        }

        public Element getMessage(BareJID roomJID) {
            Element message = new Element("message", new String[]{"type", "to", "from"}, new String[]{"groupchat", roomJID.toString(), this.sender.toString()});
            message.addChild((XMLNodeIfc)new Element("body", this.body));
            return message;
        }
    }

    public static class QueueWriter
    implements PacketWriter {
        public final Queue<Packet> queue = new ArrayDeque<Packet>();

        public void write(Collection<Packet> packets) {
            this.queue.addAll(packets);
        }

        public void write(Packet packet) {
            this.queue.add(packet);
        }

        public void write(Packet packet, AsyncCallback callback) {
            throw new UnsupportedOperationException();
        }
    }
}

