/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import tigase.form.Field;
import tigase.form.Form;
import tigase.muc.RoomConfig;
import tigase.xmpp.jid.BareJID;

public class RoomConfigTest {
    @Test
    public void testCompareAndStatusGeneration() throws Exception {
        RoomConfig rc1 = new RoomConfig(BareJID.bareJIDInstance((String)"a@b"));
        RoomConfig rc2 = new RoomConfig(BareJID.bareJIDInstance((String)"a@b"));
        Assert.assertEquals((long)0L, (long)rc2.calculateStatusCodesByDiff(rc1).length);
        rc2.setValues("muc#roomconfig_whois", new String[]{"anyone"});
        Assert.assertEquals((long)1L, (long)rc2.calculateStatusCodesByDiff(rc1).length);
        Assert.assertEquals((Object)172, (Object)rc2.calculateStatusCodesByDiff(rc1)[0]);
        rc1.copyFrom(rc2);
        rc2.setValues("muc#roomconfig_whois", new String[]{"moderators"});
        Assert.assertEquals((long)1L, (long)rc2.calculateStatusCodesByDiff(rc1).length);
        Assert.assertEquals((Object)173, (Object)rc2.calculateStatusCodesByDiff(rc1)[0]);
        rc2.setValues("muc#roomconfig_enablelogging", new String[]{"1"});
        List<Integer> codes = Arrays.asList(rc2.calculateStatusCodesByDiff(rc1));
        Assert.assertEquals((long)2L, (long)codes.size());
        Assert.assertTrue((boolean)codes.contains(173));
        Assert.assertTrue((boolean)codes.contains(170));
    }

    @Test
    public void conversionTest() throws Exception {
        RoomConfig rc1 = new RoomConfig(BareJID.bareJIDInstance((String)"a@b"));
        Assert.assertEquals((Object)RoomConfig.WhoisPrivilege.moderators, (Object)rc1.getWhois());
        Form frm = new Form("submit", null, null);
        Field anon = Field.fieldListSingle((String)"muc#roomconfig_anonymity", (String)"nonanonymous", (String)"Anonymous", (String[])new String[]{""}, (String[])new String[]{"nonanonymous"});
        frm.addField(anon);
        rc1.copyFrom(frm);
        Assert.assertEquals((Object)RoomConfig.WhoisPrivilege.anyone, (Object)rc1.getWhois());
        frm = new Form("submit", null, null);
        anon = Field.fieldListSingle((String)"muc#roomconfig_anonymity", (String)"fullanonymous", (String)"Anonymous", (String[])new String[]{""}, (String[])new String[]{"nonanonymous"});
        frm.addField(anon);
        rc1.copyFrom(frm);
        Assert.assertEquals((Object)RoomConfig.WhoisPrivilege.moderators, (Object)rc1.getWhois());
        frm = new Form("submit", null, null);
        anon = Field.fieldListSingle((String)"muc#roomconfig_anonymity", (String)"semianonymous", (String)"Anonymous", (String[])new String[]{""}, (String[])new String[]{"nonanonymous"});
        frm.addField(anon);
        rc1.copyFrom(frm);
        Assert.assertEquals((Object)RoomConfig.WhoisPrivilege.moderators, (Object)rc1.getWhois());
        frm = new Form("submit", null, null);
        anon = Field.fieldListSingle((String)"muc#roomconfig_anonymity", (String)"invalid value", (String)"Anonymous", (String[])new String[]{""}, (String[])new String[]{"nonanonymous"});
        frm.addField(anon);
        rc1.copyFrom(frm);
        Assert.assertEquals((Object)RoomConfig.WhoisPrivilege.moderators, (Object)rc1.getWhois());
        frm = new Form("submit", null, null);
        rc1.copyFrom(frm);
        Assert.assertEquals((Object)RoomConfig.WhoisPrivilege.moderators, (Object)rc1.getWhois());
    }
}

