/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import tigase.component.DSLBeanConfigurator;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfigWriter;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.Repository;
import tigase.db.beans.DataSourceBean;
import tigase.db.xml.XMLDataSource;
import tigase.db.xml.XMLRepository;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.AbstractKernelTestCase;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.muc.PermissionChecker;
import tigase.muc.RoomAffiliation;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.TestMUCCompoent;
import tigase.muc.repository.AbstractMucDAO;
import tigase.muc.repository.IMucDAO;
import tigase.muc.utils.ArrayWriter;
import tigase.vhosts.DummyVHostManager;
import tigase.xml.db.DBElement;
import tigase.xml.db.NodeNotFoundException;
import tigase.xml.db.XMLDB;
import tigase.xmpp.jid.BareJID;

public class AbstractMucTest
extends AbstractKernelTestCase {
    protected ArrayWriter writer;

    protected final Kernel getMucKernel() {
        return (Kernel)this.getKernel().getInstance("muc#KERNEL");
    }

    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        kernel.registerBean("defaultBeanConfigurator").asClass(DSLBeanConfigurator.class).exportable().exec();
        DSLBeanConfigurator config = (DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class);
        Map<String, String> props = new HashMap<String, String>();
        props.put("name", "muc");
        props.put("statistics", "false");
        props = ConfigWriter.buildTree(props);
        ((DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class)).setProperties(props);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("vHostManager").asClass(DummyVHostManager.class).exportable().setActive(true).exec();
        try {
            String xmlRepositoryURI = "memory://xmlRepo?autoCreateUser=true";
            kernel.registerBean("default").asClass(XMLDataSource.class).exportable().exec();
            XMLDataSource xmlDataSource = (XMLDataSource)kernel.getInstance(XMLDataSource.class);
            xmlDataSource.initialize(xmlRepositoryURI);
            kernel.registerBean("instance").asClass(XMLRepository.class).exportable().exec();
            XMLRepository repository = (XMLRepository)kernel.getInstance(XMLRepository.class);
            repository.setDataSource(xmlDataSource);
            Class daoClass = DataSourceHelper.getDefaultClass(IMucDAO.class, (String)xmlRepositoryURI);
            kernel.registerBean("muc-dao").asClass(daoClass).exportable().exec();
            kernel.registerBean(DataSourceBean.class).exportable().exec();
            DataSourceBean dataSourceBean = (DataSourceBean)kernel.getInstance(DataSourceBean.class);
            dataSourceBean.addRepo("default", (DataSource)xmlDataSource);
            IMucDAO iMucDAO = (IMucDAO)kernel.getInstance("muc-dao");
            iMucDAO.setDataSource((DataSource)xmlDataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        kernel.registerBean("muc").asClass(TestMUCCompoent.class).exportable().exec();
        kernel.getInstance(TestMUCCompoent.class);
        this.getMucKernel().registerBean(PermissionChecker.class).exec();
        this.writer = new ArrayWriter();
        this.getMucKernel().registerBean("writer").asInstance((Object)this.writer).exec();
    }

    @Repository.Meta(supportedUris={"memory://.*"}, isDefault=true)
    public static class MucAbstractMucDAO
    extends AbstractMucDAO<XMLDataSource, Long> {
        AtomicLong id = new AtomicLong(0L);
        XMLDB xmldb;
        final String affiliations_key = "affiliations";

        public Long createRoom(RoomWithId<Long> room) throws RepositoryException {
            try {
                this.xmldb.addNode1(room.getRoomJID().toString());
                this.xmldb.setData(room.getRoomJID().toString(), "room", room);
                this.xmldb.setData(room.getRoomJID().toString(), "config", (Object)room.getConfig());
                return this.id.getAndIncrement();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void destroyRoom(BareJID roomJID) throws RepositoryException {
            try {
                this.xmldb.removeNode1(roomJID.toString());
            }
            catch (NodeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public Map<BareJID, RoomAffiliation> getAffiliations(RoomWithId<Long> room) throws RepositoryException {
            DBElement node1 = this.xmldb.findNode1(room.getRoomJID().toString());
            try {
                String[] JIDS = this.xmldb.getKeys(room.getRoomJID().toString(), "affiliations");
                HashMap<BareJID, RoomAffiliation> affiliations = new HashMap<BareJID, RoomAffiliation>(JIDS.length);
                for (String jid : JIDS) {
                    RoomAffiliation affiliation = (RoomAffiliation)this.xmldb.getData(room.getRoomJID().toString(), "affiliations", jid);
                    affiliations.put(BareJID.bareJIDInstanceNS((String)jid), affiliation);
                }
                return affiliations;
            }
            catch (NodeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public RoomWithId<Long> getRoom(BareJID roomJID) throws RepositoryException {
            try {
                return (RoomWithId)this.xmldb.getData(roomJID.toString(), "room");
            }
            catch (NodeNotFoundException e) {
                return null;
            }
        }

        public List<BareJID> getRoomsJIDList() throws RepositoryException {
            return this.xmldb.getAllNode1s().stream().map(BareJID::bareJIDInstanceNS).toList();
        }

        public void setAffiliation(RoomWithId<Long> room, BareJID jid, RoomAffiliation affiliation) throws RepositoryException {
            try {
                this.xmldb.setData(room.getRoomJID().toString(), "affiliations", jid.toString(), (Object)affiliation);
            }
            catch (NodeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public String getRoomAvatar(RoomWithId<Long> room) throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public void setDataSource(XMLDataSource dataSource) throws RepositoryException {
            this.xmldb = dataSource.getXMLDB();
        }

        public void updateRoomAvatar(RoomWithId<Long> room, String encodedAvatar, String hash) throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public void setSubject(RoomWithId<Long> room, String subject, String creatorNickname, Date changeDate) throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public void updateRoomConfig(RoomConfig roomConfig) throws RepositoryException {
            throw new UnsupportedOperationException();
        }
    }
}

